"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/kibana-utils-plugin/common");
var _common2 = require("../common");
var _capabilities_provider = require("./capabilities_provider");
var _embeddable = require("./embeddable");
var _locator = require("./locator");
var _sample_data = require("./sample_data");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DiscoverServerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    core.uiSettings.register((0, _ui_settings.getUiSettings)(core.docLinks, this.config.enableUiSettingsValidations));
    if (plugins.home) {
      (0, _sample_data.registerSampleData)(plugins.home.sampleData);
    }
    if (plugins.share) {
      plugins.share.url.locators.create(new _common2.DiscoverAppLocatorDefinition({
        useHash: false,
        setStateToKbnUrl: _common.setStateToKbnUrl
      }));
    }
    plugins.embeddable.registerEmbeddableFactory((0, _embeddable.createSearchEmbeddableFactory)());
    return {};
  }
  start(core, deps) {
    return {
      locator: (0, _locator.initializeLocatorServices)(core, deps)
    };
  }
  stop() {}
}
exports.DiscoverServerPlugin = DiscoverServerPlugin;