"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSecurityRootProfileProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _profiles = require("../../../profiles");
var _get_cell_renderer_accessor = require("../accessors/get_cell_renderer_accessor");
var _create_app_wrapper_accessor = require("../accessors/create_app_wrapper_accessor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EmptyAppWrapper = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const createSecurityRootProfileProvider = services => {
  const {
    discoverShared
  } = services;
  const discoverFeaturesRegistry = discoverShared.features.registry;
  const cellRendererFeature = discoverFeaturesRegistry.getById('security-solution-cell-renderer');
  const appWrapperFeature = discoverFeaturesRegistry.getById('security-solution-app-wrapper');
  return {
    profileId: 'security-root-profile',
    isExperimental: true,
    profile: {
      getRenderAppWrapper: (PrevWrapper, params) => {
        var _params$context$appWr;
        const AppWrapper = (_params$context$appWr = params.context.appWrapper) !== null && _params$context$appWr !== void 0 ? _params$context$appWr : EmptyAppWrapper;
        return ({
          children
        }) => /*#__PURE__*/_react.default.createElement(PrevWrapper, null, /*#__PURE__*/_react.default.createElement(AppWrapper, null, children));
      },
      getCellRenderers: (prev, {
        context
      }) => params => {
        const entries = prev(params);
        ['host.name', 'user.name', 'source.ip', 'destination.ip'].forEach(fieldName => {
          var _context$getCellRende, _context$getCellRende2;
          entries[fieldName] = (_context$getCellRende = (_context$getCellRende2 = context.getCellRenderer) === null || _context$getCellRende2 === void 0 ? void 0 : _context$getCellRende2.call(context, fieldName)) !== null && _context$getCellRende !== void 0 ? _context$getCellRende : entries[fieldName];
        });
        return entries;
      }
    },
    resolve: async params => {
      if (params.solutionNavId !== _profiles.SolutionType.Security) {
        return {
          isMatch: false
        };
      }
      const getAppWrapper = await (0, _create_app_wrapper_accessor.createAppWrapperAccessor)(appWrapperFeature);
      const getCellRenderer = await (0, _get_cell_renderer_accessor.createCellRendererAccessor)(cellRendererFeature);
      return {
        isMatch: true,
        context: {
          solutionType: _profiles.SolutionType.Security,
          appWrapper: getAppWrapper === null || getAppWrapper === void 0 ? void 0 : getAppWrapper(),
          getCellRenderer
        }
      };
    }
  };
};
exports.createSecurityRootProfileProvider = createSecurityRootProfileProvider;