"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRowAdditionalLeadingControls = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _esqlUtils = require("@kbn/esql-utils");
var _esQuery = require("@kbn/es-query");
var _esqlAst = require("@kbn/esql-ast");
var _field_constants = require("@kbn/discover-utils/src/field_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getRowAdditionalLeadingControls = prev => params => {
  const additionalControls = prev(params) || [];
  const {
    updateESQLQuery,
    query
  } = params;
  const isDegradedDocsControlEnabled = (0, _esQuery.isOfAggregateQueryType)(query) ? queryContainsMetadataIgnored(query) : true;
  const addIgnoredMetadataToQuery = updateESQLQuery ? () => {
    updateESQLQuery(prevQuery => {
      const {
        root
      } = (0, _esqlAst.parse)(prevQuery);
      // Add _ignored field to metadata directive if not present
      _esqlAst.mutate.commands.from.metadata.upsert(root, _field_constants.IGNORED_FIELD);
      return _esqlAst.BasicPrettyPrinter.print(root);
    });
  } : undefined;
  return [...additionalControls, (0, _discoverUtils.createDegradedDocsControl)({
    enabled: isDegradedDocsControlEnabled,
    addIgnoredMetadataToQuery
  }), (0, _discoverUtils.createStacktraceControl)()];
};
exports.getRowAdditionalLeadingControls = getRowAdditionalLeadingControls;
const queryContainsMetadataIgnored = query => (0, _esqlUtils.retrieveMetadataColumns)(query.esql).includes('_ignored');