"use strict";

var _scout = require("@kbn/scout");
var _fixtures = require("../fixtures");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

_fixtures.spaceTest.describe('Discover app - value suggestions: useTimeRange enabled', {
  tag: _scout.tags.DEPLOYMENT_AGNOSTIC
}, () => {
  _fixtures.spaceTest.beforeAll(async ({
    scoutSpace
  }) => {
    await scoutSpace.savedObjects.load(_fixtures.testData.KBN_ARCHIVES.DASHBOARD_DRILLDOWNS);
    await scoutSpace.uiSettings.setDefaultIndex(_fixtures.testData.DATA_VIEW_NAME.LOGSTASH);
    await scoutSpace.uiSettings.setDefaultTime({
      from: _fixtures.testData.LOGSTASH_DEFAULT_START_TIME,
      to: _fixtures.testData.LOGSTASH_DEFAULT_END_TIME
    });
  });
  _fixtures.spaceTest.beforeEach(async ({
    browserAuth,
    pageObjects
  }) => {
    await browserAuth.loginAsViewer();
    await pageObjects.discover.goto();
  });
  _fixtures.spaceTest.afterAll(async ({
    scoutSpace
  }) => {
    await scoutSpace.uiSettings.unset('defaultIndex', 'timepicker:timeDefaults');
    await scoutSpace.savedObjects.cleanStandardList();
  });
  (0, _fixtures.spaceTest)('dont show up if outside of range', async ({
    page,
    pageObjects
  }) => {
    await pageObjects.datePicker.setAbsoluteRange(_fixtures.testData.LOGSTASH_OUT_OF_RANGE_DATES);
    await page.testSubj.fill('queryInput', 'extension.raw : ');
    await (0, _scout.expect)(page.testSubj.locator('autoCompleteSuggestionText')).toHaveCount(0);
  });
  (0, _fixtures.spaceTest)('show up if in range', async ({
    page,
    pageObjects
  }) => {
    await pageObjects.datePicker.setAbsoluteRange(_fixtures.testData.LOGSTASH_IN_RANGE_DATES);
    await page.testSubj.fill('queryInput', 'extension.raw : ');
    await (0, _scout.expect)(page.testSubj.locator('autoCompleteSuggestionText'), _fixtures.assertionMessages.QUERY_BAR_VALIDATION.SUGGESTIONS_COUNT).toHaveCount(5);
    const actualSuggestions = await page.testSubj.locator('autoCompleteSuggestionText').allTextContents();
    (0, _scout.expect)(actualSuggestions.join(',')).toContain('jpg');
  });
  (0, _fixtures.spaceTest)('also displays descriptions for operators', async ({
    page,
    pageObjects
  }) => {
    await pageObjects.datePicker.setAbsoluteRange(_fixtures.testData.LOGSTASH_IN_RANGE_DATES);
    await page.testSubj.fill('queryInput', 'extension.raw');
    await (0, _scout.expect)(page.testSubj.locator('^autocompleteSuggestion-operator')).toHaveCount(2);
  });
});