"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _services = require("./services");
var _routes = require("./routes");
var _register_routes = require("./routes/register_routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DatasetQualityServerPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "dataTelemetryService", void 0);
    this.logger = initializerContext.logger.get();
    this.dataTelemetryService = new _services.DataTelemetryService(this.logger);
  }
  setup(core, plugins) {
    const resourcePlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    const getEsCapabilities = async () => {
      return await core.getStartServices().then(services => {
        const [coreStart] = services;
        return coreStart.elasticsearch.getCapabilities();
      });
    };
    (0, _register_routes.registerRoutes)({
      core,
      logger: this.logger,
      repository: (0, _routes.getDatasetQualityServerRouteRepository)(),
      plugins: resourcePlugins,
      getEsCapabilities
    });

    // Setup Data Telemetry Service
    this.dataTelemetryService.setup(plugins.taskManager, plugins.usageCollection);
    return {};
  }
  start(core, plugins) {
    // Start Data Telemetry Service
    this.dataTelemetryService.start(plugins.telemetry, core, plugins.taskManager).catch(error => {
      this.logger.error(`[Data Telemetry Service]: ${error}`);
    });
    return {};
  }
}
exports.DatasetQualityServerPlugin = DatasetQualityServerPlugin;