"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFlyout = createFlyout;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function createFlyout(coreStart, share, data, props) {
  const {
    http,
    overlays,
    application: {
      currentAppId$
    },
    ...startServices
  } = coreStart;
  const LazyFlyoutContents = /*#__PURE__*/(0, _react.lazy)(async () => {
    const {
      FlyoutContents
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./flyout_contents')));
    return {
      default: FlyoutContents
    };
  });
  let results = null;
  const {
    onUploadComplete,
    autoAddInference,
    indexSettings
  } = props;
  const onFlyoutClose = () => {
    flyoutSession.close();
    if (results !== null && typeof onUploadComplete === 'function') {
      onUploadComplete(results);
    }
  };
  const flyoutSession = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(LoadingContents, null)
  }, /*#__PURE__*/_react.default.createElement(LazyFlyoutContents, {
    coreStart: coreStart,
    share: share,
    data: data,
    props: {
      autoAddInference,
      indexSettings
    },
    onFlyoutClose: onFlyoutClose,
    setUploadResults: res => {
      if (res) {
        results = res;
      }
    }
  })), startServices), {
    'data-test-subj': 'mlFlyoutLayerSelector',
    ownFocus: true,
    onClose: onFlyoutClose,
    size: '500px'
  });

  // Close the flyout when user navigates out of the current plugin
  currentAppId$.pipe((0, _rxjs.skip)(1), (0, _rxjs.takeUntil)((0, _rxjs.from)(flyoutSession.onClose)), (0, _rxjs.distinctUntilChanged)()).subscribe(() => {
    flyoutSession.close();
  });
}
const LoadingContents = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.dataVisualizer.file.uploadView.uploadFileTitle",
  defaultMessage: "Upload a file"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null));