"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleDistributionChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _common = require("@kbn/field-formats-plugin/common");
var _i18n = require("@kbn/i18n");
var _data_drift_chart_tooltip_body = require("../data_drift_chart_tooltip_body");
var _constants = require("../constants");
var _default_value_formatter = require("./default_value_formatter");
var _no_charts_data = require("./no_charts_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SingleDistributionChart = ({
  data,
  color,
  fieldType,
  secondaryType,
  name
}) => {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const xAxisFormatter = (0, _default_value_formatter.useFieldFormatter)((0, _default_value_formatter.getFieldFormatType)(secondaryType));
  const yAxisFormatter = (0, _default_value_formatter.useFieldFormatter)(_common.FIELD_FORMAT_IDS.NUMBER);
  if (data.length === 0) return /*#__PURE__*/_react.default.createElement(_no_charts_data.NoChartsData, {
    textAlign: "left"
  });
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    body: _data_drift_chart_tooltip_body.DataComparisonChartTooltipBody
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    theme: {
      axes: {
        gridLine: {
          horizontal: {
            visible: false
          },
          vertical: {
            visible: false
          }
        }
      } // Hide grid lines
    },
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "vertical",
    position: _charts.Position.Left,
    tickFormat: yAxisFormatter,
    domain: {
      min: 0,
      max: 1
    },
    hide: true
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: xAxisFormatter,
    labelFormat: xAxisFormatter,
    hide: true
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: `${name}-distr-viz`,
    name: name,
    xScaleType: fieldType === _constants.DATA_COMPARISON_TYPE.NUMERIC ? _charts.ScaleType.Linear : _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['percentage'],
    data: data,
    color: color
  }));
};
exports.SingleDistributionChart = SingleDistributionChart;