"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = exports.getBreadcrumbValue = void 0;
var _react = require("react");
var _common = require("@kbn/dataset-quality-plugin/common");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _common2 = require("../../common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = (breadcrumbs = []) => {
  const {
    services: {
      appParams,
      chrome,
      share
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  (0, _react.useEffect)(() => {
    const locator = share.url.locators.get(_deeplinksObservability.DATA_QUALITY_LOCATOR_ID);
    const composedBreadcrumbs = [{
      text: _common2.PLUGIN_NAME,
      deepLinkId: 'management:data_quality',
      onClick: () => locator === null || locator === void 0 ? void 0 : locator.navigate({})
    }, ...breadcrumbs];
    chrome.docTitle.change(composedBreadcrumbs.at(-1).text);
    appParams.setBreadcrumbs(composedBreadcrumbs);
  }, [appParams, breadcrumbs, chrome, share]);
};
exports.useBreadcrumbs = useBreadcrumbs;
const getBreadcrumbValue = (dataStream, integration) => {
  var _integration$datasets;
  const {
    dataset
  } = (0, _common.indexNameToDataStreamParts)(dataStream);
  return (integration === null || integration === void 0 ? void 0 : (_integration$datasets = integration.datasets) === null || _integration$datasets === void 0 ? void 0 : _integration$datasets[dataset]) || dataset;
};
exports.getBreadcrumbValue = getBreadcrumbValue;