"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerActions = void 0;
var _public = require("@kbn/embeddable-plugin/public");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const registerActions = async plugins => {
  const {
    uiActions,
    share
  } = plugins;
  uiActions.registerActionAsync(_constants.ACTION_CLONE_PANEL, async () => {
    const {
      ClonePanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions_module')));
    return new ClonePanelAction();
  });
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, _constants.ACTION_CLONE_PANEL);
  uiActions.registerActionAsync(_constants.ACTION_EXPAND_PANEL, async () => {
    const {
      ExpandPanelAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions_module')));
    return new ExpandPanelAction();
  });
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, _constants.ACTION_EXPAND_PANEL);
  uiActions.registerActionAsync(_constants.BADGE_FILTERS_NOTIFICATION, async () => {
    const {
      FiltersNotificationAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions_module')));
    return new FiltersNotificationAction();
  });
  uiActions.attachAction(_public.PANEL_NOTIFICATION_TRIGGER, _constants.BADGE_FILTERS_NOTIFICATION);
  if (share) {
    uiActions.registerActionAsync(_constants.ACTION_EXPORT_CSV, async () => {
      const {
        ExportCSVAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions_module')));
      return new ExportCSVAction();
    });
    uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, _constants.ACTION_EXPORT_CSV);
  }
  uiActions.registerActionAsync(_constants.ACTION_ADD_TO_LIBRARY, async () => {
    const {
      AddToLibraryAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions_module')));
    return new AddToLibraryAction();
  });
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, _constants.ACTION_ADD_TO_LIBRARY);
  uiActions.registerActionAsync(_constants.ACTION_UNLINK_FROM_LIBRARY, async () => {
    const {
      UnlinkFromLibraryAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions_module')));
    return new UnlinkFromLibraryAction();
  });
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, _constants.ACTION_UNLINK_FROM_LIBRARY);
  uiActions.registerActionAsync(_constants.ACTION_COPY_TO_DASHBOARD, async () => {
    const {
      CopyToDashboardAction
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./actions_module')));
    return new CopyToDashboardAction();
  });
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, _constants.ACTION_COPY_TO_DASHBOARD);
};
exports.registerActions = registerActions;