"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToLibraryAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/saved-objects-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _kibana_services = require("../services/kibana_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => {
  var _api$parentApi;
  return Boolean((0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasLibraryTransforms)(api) && (0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && typeof ((_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.replacePanel) === 'function');
};
class AddToLibraryAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_ADD_TO_LIBRARY);
    (0, _defineProperty2.default)(this, "order", 8);
    (0, _defineProperty2.default)(this, "grouping", [_constants.DASHBOARD_ACTION_GROUP]);
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    return 'folderCheck';
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) return false;
    return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' && (await embeddable.canLinkToLibrary());
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    const lastTitle = (0, _presentationPublishing.getTitle)(embeddable);
    try {
      const {
        byRefPackage,
        libraryTitle
      } = await new Promise((resolve, reject) => {
        const onSave = async ({
          newTitle,
          isTitleDuplicateConfirmed,
          onTitleDuplicate
        }) => {
          await embeddable.checkForDuplicateTitle(newTitle, isTitleDuplicateConfirmed, onTitleDuplicate);
          try {
            const libraryId = await embeddable.saveToLibrary(newTitle);
            const {
              rawState,
              references
            } = embeddable.getSerializedStateByReference(libraryId);
            resolve({
              byRefPackage: {
                serializedState: {
                  rawState: {
                    ...rawState,
                    title: newTitle
                  },
                  references
                },
                panelType: embeddable.type
              },
              libraryTitle: newTitle
            });
            return {
              id: libraryId
            };
          } catch (error) {
            reject(error);
            return {
              error
            };
          }
        };
        (0, _public.showSaveModal)(/*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
          onSave: onSave,
          onClose: () => {},
          title: lastTitle !== null && lastTitle !== void 0 ? lastTitle : '',
          showCopyOnSave: false,
          objectType: typeof embeddable.getTypeDisplayName === 'function' ? embeddable.getTypeDisplayName() : embeddable.type,
          showDescription: false
        }));
      });
      await embeddable.parentApi.replacePanel(embeddable.uuid, byRefPackage);
      _kibana_services.coreServices.notifications.toasts.addSuccess({
        title: _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getSuccessMessage(`'${libraryTitle}'`),
        'data-test-subj': 'addPanelToLibrarySuccess'
      });
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _dashboard_actions_strings.dashboardAddToLibraryActionStrings.getErrorMessage(lastTitle),
        'data-test-subj': 'addPanelToLibraryError'
      });
    }
  }
}
exports.AddToLibraryAction = AddToLibraryAction;