"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverEmptyMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_strings = require("../options_list_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const OptionsListPopoverEmptyMessage = ({
  showOnlySelected
}) => {
  const {
    api,
    stateManager
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [searchTechnique, searchStringValid, field] = (0, _presentationPublishing.useBatchedPublishingSubjects)(stateManager.searchTechnique, stateManager.searchStringValid, api.field$);
  const noResultsMessage = (0, _react.useMemo)(() => {
    if (showOnlySelected) {
      return _options_list_strings.OptionsListStrings.popover.getSelectionsEmptyMessage();
    }
    if (!searchStringValid && field && searchTechnique) {
      return _options_list_strings.OptionsListStrings.popover.getInvalidSearchMessage(field.type);
    }
    return _options_list_strings.OptionsListStrings.popover.getEmptyMessage();
  }, [showOnlySelected, field, searchStringValid, searchTechnique]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
    tabIndex: 0,
    "data-test-subj": `optionsList-control-${showOnlySelected ? 'selectionsEmptyMessage' : 'noSelectionsMessage'}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: searchStringValid ? 'minusInCircle' : 'alert',
    color: searchStringValid ? 'default' : 'danger'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), noResultsMessage);
};
exports.OptionsListPopoverEmptyMessage = OptionsListPopoverEmptyMessage;