"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroup = ControlGroup;
var _react = _interopRequireWildcard(require("react"));
var _core = require("@dnd-kit/core");
var _sortable = require("@dnd-kit/sortable");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _control_group_strings = require("../control_group_strings");
var _control_clone = require("./control_clone");
var _control_renderer = require("./control_renderer");
require("./control_group.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ControlGroup({
  applySelections,
  controlGroupApi,
  controlsManager,
  labelPosition,
  hasUnappliedSelections
}) {
  const [isInitialized, setIsInitialized] = (0, _react.useState)(false);
  const [autoApplySelections, controlsInOrder] = (0, _presentationPublishing.useBatchedPublishingSubjects)(controlGroupApi.autoApplySelections$, controlsManager.controlsInOrder$);

  /** Handle drag and drop */
  const sensors = (0, _core.useSensors)((0, _core.useSensor)(_core.PointerSensor), (0, _core.useSensor)(_core.KeyboardSensor, {
    coordinateGetter: _sortable.sortableKeyboardCoordinates
  }));
  const [draggingId, setDraggingId] = (0, _react.useState)(null);
  const onDragEnd = (0, _react.useCallback)(({
    over,
    active
  }) => {
    var _active$data$current, _over$data$current, _document$activeEleme;
    const oldIndex = active === null || active === void 0 ? void 0 : (_active$data$current = active.data.current) === null || _active$data$current === void 0 ? void 0 : _active$data$current.sortable.index;
    const newIndex = over === null || over === void 0 ? void 0 : (_over$data$current = over.data.current) === null || _over$data$current === void 0 ? void 0 : _over$data$current.sortable.index;
    if (oldIndex !== undefined && newIndex !== undefined && oldIndex !== newIndex) {
      controlsManager.controlsInOrder$.next((0, _sortable.arrayMove)([...controlsInOrder], oldIndex, newIndex));
    }
    (_document$activeEleme = document.activeElement) === null || _document$activeEleme === void 0 ? void 0 : _document$activeEleme.blur(); // hide hover actions on drop; otherwise, they get stuck
    setDraggingId(null);
  }, [controlsInOrder, controlsManager.controlsInOrder$]);
  (0, _react.useEffect)(() => {
    let ignore = false;
    controlGroupApi.untilInitialized().then(() => {
      if (!ignore) {
        setIsInitialized(true);
      }
    });
    return () => {
      ignore = true;
    };
  }, [controlGroupApi]);
  const ApplyButtonComponent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      disabled: !hasUnappliedSelections,
      iconSize: "m",
      display: "fill",
      color: 'success',
      iconType: 'check',
      "data-test-subj": "controlGroup--applyFiltersButton",
      "aria-label": _control_group_strings.ControlGroupStrings.management.getApplyButtonTitle(hasUnappliedSelections),
      onClick: applySelections
    });
  }, [hasUnappliedSelections, applySelections]);
  if (controlsInOrder.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
        display: ${isInitialized ? 'none' : 'default'};
      `,
    borderRadius: "m",
    paddingSize: "none",
    color: draggingId ? 'success' : 'transparent',
    className: "controlsWrapper",
    "data-test-subj": "controls-group-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    responsive: false,
    "data-test-subj": "controls-group"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_core.DndContext, {
    onDragStart: ({
      active
    }) => setDraggingId(`${active.id}`),
    onDragEnd: onDragEnd,
    onDragCancel: () => setDraggingId(null),
    sensors: sensors,
    measuring: {
      droppable: {
        strategy: _core.MeasuringStrategy.BeforeDragging
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_sortable.SortableContext, {
    items: controlsInOrder,
    strategy: _sortable.rectSortingStrategy
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "controlGroup",
    alignItems: "center",
    gutterSize: "s",
    wrap: true
  }, controlsInOrder.map(({
    id,
    type
  }) => /*#__PURE__*/_react.default.createElement(_control_renderer.ControlRenderer, {
    key: id,
    uuid: id,
    type: type,
    getParentApi: () => controlGroupApi,
    onApiAvailable: controlApi => {
      controlsManager.setControlApi(id, controlApi);
    },
    isControlGroupInitialized: isInitialized
  })))), /*#__PURE__*/_react.default.createElement(_core.DragOverlay, null, draggingId ? /*#__PURE__*/_react.default.createElement(_control_clone.ControlClone, {
    key: draggingId,
    labelPosition: labelPosition,
    controlApi: controlsManager.getControlApi(draggingId)
  }) : null))), !autoApplySelections && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "controlGroup--endButtonGroup"
  }, hasUnappliedSelections ? ApplyButtonComponent : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _control_group_strings.ControlGroupStrings.management.getApplyButtonTitle(false)
  }, ApplyButtonComponent))));
}