"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConsole = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _embeddable_console = require("../../../types/embeddable_console");
var store = _interopRequireWildcard(require("../../stores/embeddable_console"));
var _load_from = require("../../lib/load_from");
require("./_index.scss");
var _console_resize_button = require("./console_resize_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const KBN_BODY_CONSOLE_CLASS = 'kbnBody--hasEmbeddableConsole';
const landmarkHeading = _i18n.i18n.translate('console.embeddableConsole.landmarkHeading', {
  defaultMessage: "Developer console. Press Enter to start editing. When you're done, press Escape to stop editing."
});
const ConsoleWrapper = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./console_wrapper')))).ConsoleWrapper
}));
const getInitialConsoleHeight = (getConsoleHeight, euiTheme) => {
  const lastHeight = getConsoleHeight();
  if (lastHeight) {
    try {
      const value = parseInt(lastHeight, 10);
      if (!isNaN(value) && value > 0) {
        return value;
      }
    } catch {
      // ignore bad local storage value
    }
  }
  return (0, _console_resize_button.getCurrentConsoleMaxSize)(euiTheme);
};
const EmbeddableConsole = ({
  core,
  usageCollection,
  setDispatch,
  alternateView,
  isDevMode,
  getConsoleHeight,
  setConsoleHeight
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    setGlobalCSSVariables
  } = (0, _eui.useEuiThemeCSSVariables)();
  const [consoleHeight, setConsoleHeightState] = (0, _react.useState)(getInitialConsoleHeight(getConsoleHeight, euiTheme));
  const [consoleState, consoleDispatch] = (0, _react.useReducer)(store.reducer, store.initialValue, value => ({
    ...value
  }));
  const chromeStyle = (0, _useObservable.default)(core.chrome.getChromeStyle$());
  (0, _react.useEffect)(() => {
    setDispatch(consoleDispatch);
    return () => setDispatch(null);
  }, [setDispatch, consoleDispatch]);
  (0, _react.useEffect)(() => {
    if (consoleState.view === _embeddable_console.EmbeddableConsoleView.Console && consoleState.loadFromContent) {
      (0, _load_from.setLoadFromParameter)(consoleState.loadFromContent);
    } else if (consoleState.view === _embeddable_console.EmbeddableConsoleView.Closed) {
      (0, _load_from.removeLoadFromParameter)();
    }
  }, [consoleState.view, consoleState.loadFromContent]);
  (0, _react.useEffect)(() => {
    document.body.classList.add(KBN_BODY_CONSOLE_CLASS);
    return () => document.body.classList.remove(KBN_BODY_CONSOLE_CLASS);
  }, []);
  (0, _react.useEffect)(() => {
    setGlobalCSSVariables({
      '--embedded-console-height': `${consoleHeight}px`,
      '--embedded-console-bottom': `-${consoleHeight}px`
    });
    setConsoleHeight(consoleHeight.toString());
  }, [consoleHeight, setGlobalCSSVariables, setConsoleHeight]);
  const isOpen = consoleState.view !== _embeddable_console.EmbeddableConsoleView.Closed;
  const showConsole = consoleState.view !== _embeddable_console.EmbeddableConsoleView.Closed && (consoleState.view === _embeddable_console.EmbeddableConsoleView.Console || alternateView === undefined);
  const showAlternateView = consoleState.view === _embeddable_console.EmbeddableConsoleView.Alternate && alternateView !== undefined;
  const setIsConsoleOpen = value => {
    consoleDispatch(value ? {
      type: 'open'
    } : {
      type: 'close'
    });
  };
  const toggleConsole = () => setIsConsoleOpen(!isOpen);
  const clickAlternateViewActivateButton = e => {
    e.preventDefault();
    switch (consoleState.view) {
      case _embeddable_console.EmbeddableConsoleView.Console:
      case _embeddable_console.EmbeddableConsoleView.Closed:
        consoleDispatch({
          type: 'open',
          payload: {
            alternateView: true
          }
        });
        break;
      case _embeddable_console.EmbeddableConsoleView.Alternate:
        consoleDispatch({
          type: 'open',
          payload: {
            alternateView: false
          }
        });
        break;
    }
  };
  const onKeyDown = event => {
    if (event.key === _eui.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      setIsConsoleOpen(false);
    }
  };
  const classes = (0, _classnames.default)('embeddableConsole', {
    'embeddableConsole-isOpen': isOpen,
    'embeddableConsole--classicChrome': chromeStyle === 'classic',
    'embeddableConsole--projectChrome': chromeStyle === 'project',
    'embeddableConsole--unknownChrome': chromeStyle === undefined,
    'embeddableConsole--fixed': true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    onClickOutside: toggleConsole,
    disabled: !isOpen
  }, /*#__PURE__*/_react.default.createElement("section", {
    "aria-label": landmarkHeading,
    className: classes,
    "data-test-subj": "consoleEmbeddedSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h2", null, landmarkHeading)), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: 'dark',
    wrapperProps: {
      cloneElement: true
    }
  }, /*#__PURE__*/_react.default.createElement("div", null, isOpen && /*#__PURE__*/_react.default.createElement(_console_resize_button.EmbeddedConsoleResizeButton, {
    consoleHeight: consoleHeight,
    setConsoleHeight: setConsoleHeightState
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "embeddableConsole__controls"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconType: isOpen ? 'arrowUp' : 'arrowDown',
    onClick: toggleConsole,
    className: "embeddableConsole__controls--button",
    "data-test-subj": "consoleEmbeddedControlBar",
    "data-telemetry-id": "console-embedded-controlbar-button"
  }, _i18n.i18n.translate('console.embeddableConsole.title', {
    defaultMessage: 'Console'
  })), alternateView && /*#__PURE__*/_react.default.createElement("div", {
    className: "embeddableConsole__controls--altViewButton-container"
  }, /*#__PURE__*/_react.default.createElement(alternateView.ActivationButton, {
    activeView: showAlternateView,
    onClick: clickAlternateViewActivateButton
  }))))), consoleState.consoleHasBeenOpened ? /*#__PURE__*/_react.default.createElement(ConsoleWrapper, {
    isOpen: showConsole,
    core: core,
    usageCollection: usageCollection,
    onKeyDown: onKeyDown,
    isDevMode: isDevMode
  }) : null, showAlternateView ? /*#__PURE__*/_react.default.createElement("div", {
    className: "embeddableConsole__content",
    "data-test-subj": "consoleEmbeddedBody"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), /*#__PURE__*/_react.default.createElement(alternateView.ViewContent, null)) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
    "aria-live": "assertive"
  }, _i18n.i18n.translate('console.embeddableConsole.customScreenReaderAnnouncement', {
    defaultMessage: 'There is a new region landmark called {landmarkHeading} with page level controls at the end of the document.',
    values: {
      landmarkHeading
    }
  })))));
};
exports.EmbeddableConsole = EmbeddableConsole;