"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineGraphRoute = void 0;
var _v = require("@kbn/cloud-security-posture-common/schema/graph/v1");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _constants = require("../../../common/constants");
var _v2 = require("./v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defineGraphRoute = router => router.versioned.post({
  access: 'internal',
  enableQueryVersion: true,
  path: _constants.GRAPH_ROUTE_PATH,
  security: {
    authz: {
      requiredPrivileges: ['cloud-security-posture-read']
    }
  }
}).addVersion({
  version: '1',
  validate: {
    request: {
      body: _v.graphRequestSchema
    },
    response: {
      200: {
        body: _v.graphResponseSchema
      }
    }
  }
}, async (context, request, response) => {
  var _await$cspContext$spa, _cspContext$spaces, _cspContext$spaces$sp;
  const cspContext = await context.csp;
  const {
    nodesLimit,
    showUnknownTarget = false
  } = request.body;
  const {
    originEventIds,
    start,
    end,
    esQuery
  } = request.body.query;
  const spaceId = (_await$cspContext$spa = await ((_cspContext$spaces = cspContext.spaces) === null || _cspContext$spaces === void 0 ? void 0 : (_cspContext$spaces$sp = _cspContext$spaces.spacesService) === null || _cspContext$spaces$sp === void 0 ? void 0 : _cspContext$spaces$sp.getActiveSpace(request))) === null || _await$cspContext$spa === void 0 ? void 0 : _await$cspContext$spa.id;
  const isGraphEnabled = await (await context.core).uiSettings.client.get(_managementSettingsIds.SECURITY_SOLUTION_ENABLE_GRAPH_VISUALIZATION_SETTING);
  cspContext.logger.debug(`isGraphEnabled: ${isGraphEnabled}`);
  if (!isGraphEnabled) {
    return response.notFound();
  }
  try {
    const resp = await (0, _v2.getGraph)({
      services: {
        logger: cspContext.logger,
        esClient: cspContext.esClient
      },
      query: {
        originEventIds,
        spaceId,
        start,
        end,
        esQuery
      },
      showUnknownTarget,
      nodesLimit
    });
    return response.ok({
      body: resp
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch graph ${err}`);
    cspContext.logger.error(err);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineGraphRoute = defineGraphRoute;