"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkActionBenchmarkRulesHandler = void 0;
var _rules_states = require("../../../../common/utils/rules_states");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const muteStatesMap = {
  mute: true,
  unmute: false
};
const bulkActionBenchmarkRulesHandler = async (soClient, encryptedSoClient, detectionRulesClient, rulesToUpdate, action, logger) => {
  const rulesIds = rulesToUpdate.map(rule => rule.rule_id);
  const benchmarkRules = await (0, _utils.getBenchmarkRules)(soClient, rulesIds);
  if (benchmarkRules.includes(undefined)) throw new Error('At least one of the provided benchmark rule IDs does not exist');
  const rulesKeys = rulesToUpdate.map(rule => (0, _rules_states.buildRuleKey)(rule.benchmark_id, rule.benchmark_version, rule.rule_number));
  const newRulesStates = (0, _utils.setRulesStates)(rulesKeys, muteStatesMap[action], rulesToUpdate);
  const updatedBenchmarkRulesStates = await (0, _utils.updateBenchmarkRulesStates)(encryptedSoClient, newRulesStates);
  const disabledDetectionRules = action === 'mute' ? await (0, _utils.muteDetectionRules)(soClient, detectionRulesClient, rulesIds) : [];
  return {
    updatedBenchmarkRulesStates,
    disabledDetectionRules
  };
};
exports.bulkActionBenchmarkRulesHandler = bulkActionBenchmarkRulesHandler;