"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  // Setting only allowed in the Serverless offering
  serverless: _configSchema.schema.object({
    enabled: (0, _configSchema.offeringBasedSchema)({
      serverless: _configSchema.schema.literal(true),
      options: {
        defaultValue: _configSchema.schema.contextRef('serverless')
      }
    })
  }),
  /**
   * For internal use. A list of string values (comma delimited) that will enable experimental
   * type of functionality that is not yet released. Valid values for this settings need to
   * be defined in:
   * `x-pack/solutions/security/plugins/cloud_security_posture/common/experimental_features.ts`
   * under the `allowedExperimentalValues` object
   *
   * @example
   * xpack.cloudSecurityPosture.enableExperimental:
   *   - newFeatureA
   *   - newFeatureB
   */
  enableExperimental: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: () => []
  })
});
const config = exports.config = {
  schema: configSchema,
  exposeToBrowser: {
    enableExperimental: true
  }
};