"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RadioGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RadioGroup = ({
  idSelected,
  size,
  options,
  disabled,
  onChange
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        display: flex;
        flex-flow: row wrap;
        gap: ${euiTheme.size.s};

        // Show rows for m- screens (below 768px)
        @media only screen and (max-width: ${euiTheme.breakpoint.m}px) {
          .euiToolTipAnchor {
            min-width: 100%;
          }
        }
      `
  }, options.map(option => {
    const isChecked = option.id === idSelected;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      key: option.id,
      content: option.tooltip,
      anchorProps: {
        style: {
          flex: '1 1 0'
        }
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: option.disabled || disabled,
      style: {
        border: `1px solid ${isChecked ? euiTheme.colors.primary : euiTheme.colors.lightShade}`
      }
      // Use empty string to fallback to no color
      // @ts-ignore
      ,
      color: isChecked ? 'primary' : '',
      onClick: () => onChange(option.id),
      iconType: option.icon,
      iconSide: "right",
      contentProps: {
        style: {
          justifyContent: 'flex-start'
        }
      },
      css: (0, _react2.css)`
                width: 100%;
                height: ${size === 's' ? euiTheme.size.xxl : euiTheme.size.xxxl};
                svg,
                img {
                  margin-left: auto;
                }

                &&,
                &&:hover {
                  text-decoration: none;
                }
                &:disabled {
                  svg,
                  img {
                    filter: grayscale(1);
                  }
                }
              `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
      "data-test-subj": option.testId,
      label: option.label,
      id: option.id,
      checked: isChecked,
      onChange: () => {}
    }), option.isBeta && /*#__PURE__*/_react.default.createElement("div", {
      css: (0, _react2.css)`
                    margin: auto;
                  `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "Beta",
      alignment: "middle"
    }))));
  }));
};
exports.RadioGroup = RadioGroup;