"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDetectionRule = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTION_ENGINE_URL = '/api/detection_engine';
const DETECTION_ENGINE_RULES_URL = `${DETECTION_ENGINE_URL}/rules`;
const createDetectionRule = async ({
  http,
  rule
}) => {
  const res = await http.post(DETECTION_ENGINE_RULES_URL, {
    version: _constants.DETECTION_RULE_RULES_API_CURRENT_VERSION,
    body: JSON.stringify(rule)
  });
  return res;
};
exports.createDetectionRule = createDetectionRule;