"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommentUserActionBuilder = void 0;
var _lodash = require("lodash");
var _constants = require("../../../../common/constants");
var _so_references = require("../../../attachment_framework/so_references");
var _domain = require("../../../../common/types/domain");
var _abstract_builder = require("../abstract_builder");
var _so_references2 = require("../../so_references");
var _audit_logger_utils = require("./audit_logger_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CommentUserActionBuilder extends _abstract_builder.UserActionBuilder {
  build(args) {
    var _args$action, _args$attachmentId;
    const soExtractor = (0, _so_references2.getAttachmentSOExtractor)(args.payload.attachment);
    const {
      transformedFields,
      references: refsWithExternalRefId
    } = soExtractor.extractFieldsToReferences({
      data: args.payload.attachment
    });
    const {
      attributes: extractedAttributes,
      references: extractedReferences
    } = (0, _so_references.extractPersistableStateReferencesFromSO)(transformedFields, {
      persistableStateAttachmentTypeRegistry: this.persistableStateAttachmentTypeRegistry
    });
    const action = (_args$action = args.action) !== null && _args$action !== void 0 ? _args$action : _domain.UserActionActions.update;
    const commentUserAction = this.buildCommonUserAction({
      ...args,
      action,
      valueKey: 'comment',
      value: {
        ...transformedFields,
        ...extractedAttributes
      },
      type: _domain.UserActionTypes.comment
    });
    const parameters = {
      ...commentUserAction,
      references: (0, _lodash.uniqBy)([...commentUserAction.references, ...refsWithExternalRefId, ...extractedReferences], 'id')
    };
    const verb = (0, _audit_logger_utils.getPastTenseVerb)(action);
    const getMessage = id => `User ${verb} comment id: ${commentId(args.attachmentId)} for case id: ${args.caseId} - user action id: ${id}`;
    const eventDetails = {
      getMessage,
      action,
      descriptiveAction: `case_user_action_${action}_comment`,
      savedObjectId: (_args$attachmentId = args.attachmentId) !== null && _args$attachmentId !== void 0 ? _args$attachmentId : args.caseId,
      savedObjectType: _constants.CASE_COMMENT_SAVED_OBJECT
    };
    return {
      parameters,
      eventDetails
    };
  }
}
exports.CommentUserActionBuilder = CommentUserActionBuilder;
const commentId = id => {
  return id ? id : 'unknown';
};