"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _navigation = require("../../common/navigation");
var _link_icon = require("../link_icon");
var _title = require("./title");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHeaderCss = (euiTheme, border) => (0, _react2.css)`
  margin-bottom: ${euiTheme.size.l};
  ${border && (0, _react2.css)`
    border-bottom: ${euiTheme.border.thin};
    padding-bottom: ${euiTheme.size.l};
    .euiProgress {
      top: ${euiTheme.size.l};
    }
  `}
`;
const HeaderPageComponent = ({
  showBackButton = false,
  border,
  children,
  isLoading,
  title,
  titleNode,
  'data-test-subj': dataTestSubj
}) => {
  const {
    releasePhase
  } = (0, _use_cases_context.useCasesContext)();
  const {
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const navigateToAllCasesClick = (0, _react.useCallback)(e => {
    if (e) {
      e.preventDefault();
    }
    navigateToAllCases();
  }, [navigateToAllCases]);
  return /*#__PURE__*/_react.default.createElement("header", {
    css: getHeaderCss(euiTheme, border),
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
            overflow: hidden;
            display: block;
          `
  }, showBackButton && /*#__PURE__*/_react.default.createElement("div", {
    className: "casesHeaderPage__linkBack",
    css: (0, _react2.css)`
                font-size: ${xsFontSize};
                margin-bottom: ${euiTheme.size.s};
              `
  }, /*#__PURE__*/_react.default.createElement(_link_icon.LinkIcon, {
    dataTestSubj: "backToCases",
    onClick: navigateToAllCasesClick,
    iconType: "arrowLeft"
  }, i18n.BACK_TO_ALL)), titleNode || /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: title,
    releasePhase: releasePhase
  }), border && isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent"
  })), children && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "header-page-supplements",
    css: (0, _react2.css)`
              display: block;
            `,
    grow: false
  }, children)));
};
HeaderPageComponent.displayName = 'HeaderPage';
const HeaderPage = exports.HeaderPage = /*#__PURE__*/_react.default.memo(HeaderPageComponent);