"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCase = exports.CommonUseField = void 0;
var _react = _interopRequireDefault(require("react"));
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _form = require("./form");
var _header_page = require("../header_page");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _navigation = require("../../common/navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = exports.CommonUseField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const CreateCase = exports.CreateCase = /*#__PURE__*/_react.default.memo(({
  afterCaseCreated,
  onCancel,
  onSuccess,
  timelineIntegration,
  withSteps
}) => {
  (0, _use_breadcrumbs.useCasesBreadcrumbs)(_navigation.CasesDeepLinkId.casesCreate);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    showBackButton: true,
    "data-test-subj": "case-create-title",
    title: i18n.CREATE_CASE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_form.CreateCaseForm, {
    afterCaseCreated: afterCaseCreated,
    onCancel: onCancel,
    onSuccess: onSuccess,
    timelineIntegration: timelineIntegration,
    withSteps: withSteps
  }));
});
CreateCase.displayName = 'CreateCase';