"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseActionBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _api = require("../../../common/types/api");
var _action_bar_status_item = require("./action_bar_status_item");
var i18n = _interopRequireWildcard(require("../case_view/translations"));
var _actions = require("./actions");
var _status_context_menu = require("./status_context_menu");
var _sync_alerts_switch = require("../case_settings/sync_alerts_switch");
var _formatted_date = require("../formatted_date");
var _helpers = require("./helpers");
var _use_on_refresh_case_view_page = require("../case_view/use_on_refresh_case_view_page");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_cases_features = require("../../common/use_cases_features");
var _use_get_case_connectors = require("../../containers/use_get_case_connectors");
var _use_should_disable_status = require("../actions/status/use_should_disable_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseActionBarComponent = ({
  caseData,
  isLoading,
  onUpdateField
}) => {
  var _caseConnectors$caseD, _caseConnectors$caseD2, _caseConnectors$caseD3;
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isSyncAlertsEnabled,
    metricsFeatures
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: caseConnectors
  } = (0, _use_get_case_connectors.useGetCaseConnectors)(caseData.id);
  const date = (0, _helpers.getStatusDate)(caseData);
  const title = (0, _helpers.getStatusTitle)(caseData.status);
  const refreshCaseViewPage = (0, _use_on_refresh_case_view_page.useRefreshCaseViewPage)();
  const onStatusChanged = (0, _react.useCallback)(status => onUpdateField({
    key: 'status',
    value: status
  }), [onUpdateField]);
  const currentExternalIncident = (_caseConnectors$caseD = caseConnectors === null || caseConnectors === void 0 ? void 0 : (_caseConnectors$caseD2 = caseConnectors[caseData.connector.id]) === null || _caseConnectors$caseD2 === void 0 ? void 0 : (_caseConnectors$caseD3 = _caseConnectors$caseD2.push.details) === null || _caseConnectors$caseD3 === void 0 ? void 0 : _caseConnectors$caseD3.externalService) !== null && _caseConnectors$caseD !== void 0 ? _caseConnectors$caseD : null;
  const onSyncAlertsChanged = (0, _react.useCallback)(syncAlerts => onUpdateField({
    key: 'settings',
    value: {
      ...caseData.settings,
      syncAlerts
    }
  }), [caseData.settings, onUpdateField]);
  const shouldDisableStatusFn = (0, _use_should_disable_status.useShouldDisableStatus)();
  const isStatusMenuDisabled = (0, _react.useMemo)(() => {
    return shouldDisableStatusFn([caseData]);
  }, [caseData, shouldDisableStatusFn]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    justifyContent: "flexEnd",
    "data-test-subj": "case-action-bar-wrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
          padding-right: ${euiTheme.size.l};
          border-right: ${euiTheme.border.thin};
          @media only screen and (max-width: ${euiTheme.breakpoint.m}) {
            padding-right: 0;
            border-right: 0;
          }
        `
  }, /*#__PURE__*/_react.default.createElement(_action_bar_status_item.ActionBarStatusItem, {
    title: i18n.STATUS,
    dataTestSubj: "case-view-status"
  }, /*#__PURE__*/_react.default.createElement(_status_context_menu.StatusContextMenu, {
    currentStatus: caseData.status,
    disabled: isStatusMenuDisabled,
    isLoading: isLoading,
    onStatusChanged: onStatusChanged
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    responsive: false
  }, !metricsFeatures.includes(_api.CaseMetricsFeature.LIFESPAN) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_action_bar_status_item.ActionBarStatusItem, {
    title: title,
    dataTestSubj: "case-action-bar-status-date"
  }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: date
  }))) : null, permissions.update && isSyncAlertsEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_action_bar_status_item.ActionBarStatusItem, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      component: "span",
      alignItems: "center",
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement("span", null, i18n.SYNC_ALERTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: i18n.SYNC_ALERTS_HELP
    }))),
    "data-test-subj": "case-view-sync-alerts"
  }, /*#__PURE__*/_react.default.createElement(_sync_alerts_switch.SyncAlertsSwitch, {
    disabled: isLoading,
    isSynced: caseData.settings.syncAlerts,
    onSwitchChange: onSyncAlertsChanged
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "case-refresh",
    flush: "left",
    iconType: "refresh",
    onClick: refreshCaseViewPage
  }, i18n.CASE_REFRESH)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_actions.Actions, {
    caseData: caseData,
    currentExternalIncident: currentExternalIncident
  }))));
};
CaseActionBarComponent.displayName = 'CaseActionBar';
const CaseActionBar = exports.CaseActionBar = /*#__PURE__*/_react.default.memo(CaseActionBarComponent);