"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tray = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getCloseTrayAriaLabel: () => _i18n.i18n.translate('xpack.canvas.toolbarTray.closeTrayAriaLabel', {
    defaultMessage: 'Close tray'
  })
};
const Tray = ({
  children,
  done
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "canvasTray__toggle",
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "s",
    onClick: done,
    "aria-label": strings.getCloseTrayAriaLabel(),
    iconType: "arrowDown"
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasTray"
  }, children));
};
exports.Tray = Tray;
Tray.propTypes = {
  children: _propTypes.default.node.isRequired,
  done: _propTypes.default.func.isRequired
};