"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceTransactionTypes = getServiceTransactionTypes;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceTransactionTypes({
  apmEventClient,
  serviceName,
  start,
  end,
  documentType,
  rollupInterval
}) {
  const params = {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, ...(0, _server.rangeQuery)(start, end)]
        }
      },
      aggs: {
        types: {
          terms: {
            field: _apm.TRANSACTION_TYPE,
            size: 100
          }
        }
      }
    }
  };
  const {
    aggregations
  } = await apmEventClient.search('get_service_transaction_types', params);
  const transactionTypes = (aggregations === null || aggregations === void 0 ? void 0 : aggregations.types.buckets.map(bucket => bucket.key)
  // we exclude page-exit transactions because they are not relevant for the apm app
  // and are only used for the INP values
  .filter(value => value !== 'page-exit')) || [];
  return {
    transactionTypes
  };
}