"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeEntities = mergeEntities;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mergeEntities({
  entities
}) {
  const mergedEntities = entities.reduce((map, current) => {
    const key = current['service.name'];
    if (map.has(key)) {
      const existingEntity = map.get(key);
      map.set(key, mergeFunc(current, existingEntity));
    } else {
      map.set(key, mergeFunc(current));
    }
    return map;
  }, new Map());
  return [...new Set(mergedEntities.values())];
}
function mergeFunc(entity, existingEntity) {
  var _existingEntity$dataS;
  const commonEntityFields = {
    serviceName: entity['service.name'],
    agentName: Array.isArray(entity['agent.name']) && entity['agent.name'].length > 0 ? entity['agent.name'][0] : entity['agent.name'],
    lastSeenTimestamp: entity['entity.last_seen_timestamp']
  };
  if (!existingEntity) {
    return {
      ...commonEntityFields,
      dataStreamTypes: (0, _lodash.uniq)((0, _lodash.castArray)(entity['data_stream.type'])),
      environments: (0, _lodash.uniq)((0, _lodash.compact)(Array.isArray(entity['service.environment']) ? entity['service.environment'] : [entity['service.environment']]))
    };
  }
  return {
    ...commonEntityFields,
    dataStreamTypes: (0, _lodash.uniq)((0, _lodash.compact)([...((_existingEntity$dataS = existingEntity === null || existingEntity === void 0 ? void 0 : existingEntity.dataStreamTypes) !== null && _existingEntity$dataS !== void 0 ? _existingEntity$dataS : []), ...(0, _lodash.castArray)(entity['data_stream.type'])])),
    environments: (0, _lodash.uniq)((0, _lodash.compact)([...(existingEntity === null || existingEntity === void 0 ? void 0 : existingEntity.environments), entity['service.environment']]))
  };
}