"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorCountActionVariables = void 0;
exports.registerErrorCountRuleType = registerErrorCountRuleType;
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/alerting-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _server3 = require("@kbn/observability-plugin/server");
var _common2 = require("@kbn/spaces-plugin/common");
var _std = require("@kbn/std");
var _error_count = require("@kbn/response-ops-rule-params/error_count");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _apm = require("../../../../../common/es_fields/apm");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _environment_query = require("../../../../../common/utils/environment_query");
var _formatters = require("../../../../../common/utils/formatters");
var _action_variables = require("../../action_variables");
var _alerting_es_client = require("../../alerting_es_client");
var _register_apm_rule_types = require("../../register_apm_rule_types");
var _get_apm_alert_source_fields = require("../get_apm_alert_source_fields");
var _get_groupby_terms = require("../utils/get_groupby_terms");
var _get_groupby_action_variables = require("../utils/get_groupby_action_variables");
var _get_all_groupby_fields = require("../../../../../common/rules/get_all_groupby_fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTypeConfig = _apm_rule_types.RULE_TYPES_CONFIG[_ruleDataUtils.ApmRuleType.ErrorCount];
const errorCountActionVariables = exports.errorCountActionVariables = [_action_variables.apmActionVariables.alertDetailsUrl, _action_variables.apmActionVariables.environment, _action_variables.apmActionVariables.errorGroupingKey, _action_variables.apmActionVariables.errorGroupingName, _action_variables.apmActionVariables.interval, _action_variables.apmActionVariables.reason, _action_variables.apmActionVariables.serviceName, _action_variables.apmActionVariables.threshold, _action_variables.apmActionVariables.transactionName, _action_variables.apmActionVariables.triggerValue, _action_variables.apmActionVariables.viewInAppUrl];
function registerErrorCountRuleType({
  alerting,
  alertsLocator,
  basePath,
  getApmIndices,
  logger,
  ruleDataClient
}) {
  if (!alerting) {
    throw new Error('Cannot register error count rule type. The alerting plugin needs to be enabled.');
  }
  alerting.registerType({
    id: _ruleDataUtils.ApmRuleType.ErrorCount,
    name: ruleTypeConfig.name,
    actionGroups: ruleTypeConfig.actionGroups,
    defaultActionGroupId: ruleTypeConfig.defaultActionGroupId,
    validate: {
      params: _error_count.errorCountParamsSchema
    },
    doesSetRecoveryContext: true,
    schemas: {
      params: {
        type: 'config-schema',
        schema: _error_count.errorCountParamsSchema
      }
    },
    actionVariables: {
      context: errorCountActionVariables
    },
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: _apm_rule_types.APM_SERVER_FEATURE_ID,
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: async options => {
      var _ruleParams$searchCon, _ruleParams$searchCon2, _ruleParams$searchCon3, _ruleParams$searchCon4, _response$aggregation, _response$aggregation2, _alertsClient$getReco;
      const {
        params: ruleParams,
        services,
        spaceId,
        getTimeRange
      } = options;
      const {
        alertsClient,
        savedObjectsClient,
        scopedClusterClient,
        uiSettingsClient
      } = services;
      if (!alertsClient) {
        throw new _server2.AlertsClientError();
      }
      const allGroupByFields = (0, _get_all_groupby_fields.getAllGroupByFields)(_ruleDataUtils.ApmRuleType.ErrorCount, ruleParams.groupBy);
      const indices = await getApmIndices(savedObjectsClient);
      const termFilterQuery = !((_ruleParams$searchCon = ruleParams.searchConfiguration) !== null && _ruleParams$searchCon !== void 0 && (_ruleParams$searchCon2 = _ruleParams$searchCon.query) !== null && _ruleParams$searchCon2 !== void 0 && _ruleParams$searchCon2.query) ? [...(0, _server3.termQuery)(_apm.SERVICE_NAME, ruleParams.serviceName, {
        queryEmptyString: false
      }), ...(0, _server3.termQuery)(_apm.ERROR_GROUP_ID, ruleParams.errorGroupingKey, {
        queryEmptyString: false
      }), ...(0, _environment_query.environmentQuery)(ruleParams.environment)] : [];
      const {
        dateStart
      } = getTimeRange(`${ruleParams.windowSize}${ruleParams.windowUnit}`);
      const searchParams = {
        index: indices.error,
        body: {
          track_total_hits: false,
          size: 0,
          query: {
            bool: {
              filter: [{
                range: {
                  '@timestamp': {
                    gte: dateStart
                  }
                }
              }, {
                term: {
                  [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.error
                }
              }, ...termFilterQuery, ...(0, _server3.getParsedFilterQuery)((_ruleParams$searchCon3 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon3 === void 0 ? void 0 : (_ruleParams$searchCon4 = _ruleParams$searchCon3.query) === null || _ruleParams$searchCon4 === void 0 ? void 0 : _ruleParams$searchCon4.query)]
            }
          },
          aggs: {
            error_counts: {
              multi_terms: {
                terms: (0, _get_groupby_terms.getGroupByTerms)(allGroupByFields),
                size: 1000,
                order: {
                  _count: 'desc'
                }
              },
              aggs: (0, _get_apm_alert_source_fields.getApmAlertSourceFieldsAgg)()
            }
          }
        }
      };
      const response = await (0, _alerting_es_client.alertingEsClient)({
        scopedClusterClient,
        uiSettingsClient,
        params: searchParams
      });
      const errorCountResults = (_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.error_counts.buckets.map(bucket => {
        const groupByFields = bucket.key.reduce((obj, bucketKey, bucketIndex) => {
          obj[allGroupByFields[bucketIndex]] = bucketKey;
          return obj;
        }, {});
        const bucketKey = bucket.key;
        return {
          errorCount: bucket.doc_count,
          sourceFields: (0, _get_apm_alert_source_fields.getApmAlertSourceFields)(bucket),
          groupByFields,
          bucketKey
        };
      })) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
      await (0, _std.asyncForEach)(errorCountResults.filter(result => result.errorCount >= ruleParams.threshold), async result => {
        var _getEnvironmentEsFiel;
        const {
          errorCount,
          sourceFields,
          groupByFields,
          bucketKey
        } = result;
        const alertId = bucketKey.join('_');
        const alertReason = (0, _apm_rule_types.formatErrorCountReason)({
          threshold: ruleParams.threshold,
          measured: errorCount,
          windowSize: ruleParams.windowSize,
          windowUnit: ruleParams.windowUnit,
          groupByFields
        });
        const {
          uuid
        } = alertsClient.report({
          id: alertId,
          actionGroup: ruleTypeConfig.defaultActionGroupId
        });
        const relativeViewInAppUrl = (0, _formatters.getAlertUrlErrorCount)(groupByFields[_apm.SERVICE_NAME], (_getEnvironmentEsFiel = (0, _environment_filter_values.getEnvironmentEsField)(groupByFields[_apm.SERVICE_ENVIRONMENT])) === null || _getEnvironmentEsFiel === void 0 ? void 0 : _getEnvironmentEsFiel[_apm.SERVICE_ENVIRONMENT]);
        const viewInAppUrl = (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, relativeViewInAppUrl);
        const alertDetailsUrl = await (0, _common.getAlertDetailsUrl)(basePath, spaceId, uuid);
        const groupByActionVariables = (0, _get_groupby_action_variables.getGroupByActionVariables)(groupByFields);
        const payload = {
          [_apm.PROCESSOR_EVENT]: _common.ProcessorEvent.error,
          [_ruleDataUtils.ALERT_EVALUATION_VALUE]: errorCount,
          [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: ruleParams.threshold,
          [_apm.ERROR_GROUP_ID]: ruleParams.errorGroupingKey,
          [_ruleDataUtils.ALERT_REASON]: alertReason,
          ...sourceFields,
          ...groupByFields
        };
        const context = {
          alertDetailsUrl,
          interval: (0, _common.formatDurationFromTimeUnitChar)(ruleParams.windowSize, ruleParams.windowUnit),
          reason: alertReason,
          threshold: ruleParams.threshold,
          // When group by doesn't include error.grouping_key, the context.error.grouping_key action variable will contain value of the Error Grouping Key filter
          errorGroupingKey: ruleParams.errorGroupingKey,
          triggerValue: errorCount,
          viewInAppUrl,
          ...groupByActionVariables
        };
        alertsClient.setAlertData({
          id: alertId,
          payload,
          context
        });
      });
      // Handle recovered alerts context
      const recoveredAlerts = (_alertsClient$getReco = alertsClient.getRecoveredAlerts()) !== null && _alertsClient$getReco !== void 0 ? _alertsClient$getReco : [];
      for (const recoveredAlert of recoveredAlerts) {
        var _getEnvironmentEsFiel2;
        const alertHits = recoveredAlert.hit;
        const recoveredAlertId = recoveredAlert.alert.getId();
        const alertUuid = recoveredAlert.alert.getUuid();
        const alertDetailsUrl = (0, _common.getAlertDetailsUrl)(basePath, spaceId, alertUuid);
        const groupByFields = allGroupByFields.reduce((acc, sourceField) => {
          if ((alertHits === null || alertHits === void 0 ? void 0 : alertHits[sourceField]) !== undefined) {
            acc[sourceField] = alertHits[sourceField];
          }
          return acc;
        }, {});
        const relativeViewInAppUrl = (0, _formatters.getAlertUrlErrorCount)(groupByFields[_apm.SERVICE_NAME], (_getEnvironmentEsFiel2 = (0, _environment_filter_values.getEnvironmentEsField)(groupByFields[_apm.SERVICE_ENVIRONMENT])) === null || _getEnvironmentEsFiel2 === void 0 ? void 0 : _getEnvironmentEsFiel2[_apm.SERVICE_ENVIRONMENT]);
        const viewInAppUrl = (0, _common2.addSpaceIdToPath)(basePath.publicBaseUrl, spaceId, relativeViewInAppUrl);
        const groupByActionVariables = (0, _get_groupby_action_variables.getGroupByActionVariables)(groupByFields);
        const recoveredContext = {
          alertDetailsUrl,
          interval: (0, _common.formatDurationFromTimeUnitChar)(ruleParams.windowSize, ruleParams.windowUnit),
          reason: alertHits === null || alertHits === void 0 ? void 0 : alertHits[_ruleDataUtils.ALERT_REASON],
          // When group by doesn't include error.grouping_key, the context.error.grouping_key action variable will contain value of the Error Grouping Key filter
          errorGroupingKey: ruleParams.errorGroupingKey,
          threshold: ruleParams.threshold,
          triggerValue: alertHits === null || alertHits === void 0 ? void 0 : alertHits[_ruleDataUtils.ALERT_EVALUATION_VALUE],
          viewInAppUrl,
          ...groupByActionVariables
        };
        alertsClient.setAlertData({
          id: recoveredAlertId,
          context: recoveredContext
        });
      }
      return {
        state: {}
      };
    },
    alerts: _register_apm_rule_types.ApmRuleTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  });
}