"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampTooltip = TimestampTooltip;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _formatters = require("../../../../common/utils/formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TimestampTooltip({
  time,
  timeUnit = 'milliseconds'
}) {
  const momentTime = (0, _momentTimezone.default)(time);
  const relativeTimeLabel = momentTime.fromNow();
  const absoluteTimeLabel = (0, _formatters.asAbsoluteDateTime)(time, timeUnit);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: absoluteTimeLabel
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, relativeTimeLabel));
}