"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverBadge = PopoverBadge;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("../../../../common/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PopoverBadge({
  title,
  badgeLabel = _i18n.NOT_AVAILABLE_LABEL,
  content,
  footer
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      iconType: "iInCircle",
      iconOnClick: () => setIsPopoverOpen(!isPopoverOpen),
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      iconOnClickAriaLabel: _i18n.CLICK_ARIAL_LABEL,
      onClickAriaLabel: _i18n.CLICK_ARIAL_LABEL,
      iconSide: "left",
      color: "hollow"
    }, badgeLabel),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, title), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, content))), footer && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, footer))));
}