"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotAvailableApmMetrics = NotAvailableApmMetrics;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _popover_badge = require("../popover_badge");
var _use_kibana = require("../../../context/kibana_context/use_kibana");
var _buttons = require("../add_data_buttons/buttons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NotAvailableApmMetrics() {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  function handleClick() {
    services.telemetry.reportEntityInventoryAddData({
      view: 'add_apm_n/a'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_popover_badge.PopoverBadge, {
    title: _i18n.i18n.translate('xpack.apm.servicesTable.notAvailableApmMetrics.title', {
      defaultMessage: 'Want to see more?'
    }),
    content: _i18n.i18n.translate('xpack.apm.servicesTable.notAvailableApmMetrics.content', {
      defaultMessage: 'Understand key metrics like transaction latency, throughput and error rate by instrumenting your service with APM.'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_buttons.AddApmData, {
      "data-test-subj": "apmAddDataNotAvailable",
      onClick: handleClick
    })
  });
}