"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListMetric = ListMetric;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _spark_plot = require("./charts/spark_plot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ListMetric(props) {
  const {
    hideSeries,
    ...sparkPlotProps
  } = props;
  const {
    valueLabel
  } = sparkPlotProps;
  if (!hideSeries) {
    return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, sparkPlotProps);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "right"
  }, valueLabel)));
}