"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMobileStatisticsFetcher = useMobileStatisticsFetcher;
var _uuid = require("uuid");
var _use_apm_service_context = require("../../../../../context/apm_service/use_apm_service_context");
var _use_fetcher = require("../../../../../hooks/use_fetcher");
var _get_comparison_options = require("../../../../shared/time_comparison/get_comparison_options");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INITIAL_STATE_MAIN_STATISTICS = {
  mainStatistics: [],
  requestId: undefined,
  totalItems: 0
};
const INITIAL_STATE_DETAILED_STATISTICS = {
  currentPeriod: {},
  previousPeriod: {}
};
function useMobileStatisticsFetcher({
  field,
  environment,
  start,
  end,
  kuery,
  comparisonEnabled,
  offset
}) {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data = INITIAL_STATE_MAIN_STATISTICS,
    status: mainStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end) {
      return callApmApi('GET /internal/apm/mobile-services/{serviceName}/main_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            field
          }
        }
      }).then(response => {
        return {
          // Everytime the main statistics is refetched, updates the requestId making the comparison API to be refetched.
          requestId: (0, _uuid.v4)(),
          mainStatistics: response.mainStatistics,
          totalItems: response.mainStatistics.length
        };
      });
    }
  }, [environment, start, end, kuery, serviceName, field]);
  const {
    mainStatistics,
    requestId,
    totalItems
  } = data;
  const {
    data: detailedStatistics = INITIAL_STATE_DETAILED_STATISTICS,
    status: detailedStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (totalItems && start && end) {
      return callApmApi('GET /internal/apm/mobile-services/{serviceName}/detailed_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            field,
            fieldValues: JSON.stringify(data === null || data === void 0 ? void 0 : data.mainStatistics.map(({
              name
            }) => name).sort()),
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          }
        }
      });
    }
  },
  // only fetches agg results when requestId changes

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [requestId], {
    preservePreviousData: false
  });
  return {
    mainStatistics,
    mainStatisticsStatus,
    detailedStatistics,
    detailedStatisticsStatus
  };
}