"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEcsGroups = void 0;
var _alertsAsDataUtils = require("@kbn/alerts-as-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEcsGroups = (groups = []) => {
  const ecsGroup = {};
  groups.forEach(group => {
    const path = group.field;
    const ecsField = _alertsAsDataUtils.ecsFieldMap[path];
    if (!ecsField) return;

    // we only allow keyword group values
    if (ecsField.type !== 'keyword') return;
    if (!ecsField.array) {
      // if the ecs type is not an array, assign the value
      ecsGroup[path] = group.value;
    } else {
      // otherwise the ecs type is an array, create a 1-element array
      ecsGroup[path] = [group.value];
    }
  });
  return ecsGroup;
};
exports.getEcsGroups = getEcsGroups;