"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleRunningHandler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _partially_update_rule = require("../saved_objects/partially_update_rule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TIME_TO_WAIT = 2000;
class RuleRunningHandler {
  constructor(client, logger, ruleTypeId) {
    (0, _defineProperty2.default)(this, "client", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "ruleTypeId", void 0);
    (0, _defineProperty2.default)(this, "runningTimeoutId", void 0);
    (0, _defineProperty2.default)(this, "isUpdating", false);
    (0, _defineProperty2.default)(this, "runningPromise", void 0);
    this.client = client;
    this.logger = logger;
    this.ruleTypeId = ruleTypeId;
  }
  start(ruleId, namespace) {
    this.runningTimeoutId = setTimeout(() => {
      this.setRunning(ruleId, namespace);
    }, TIME_TO_WAIT);
  }
  stop() {
    if (this.runningTimeoutId) {
      clearTimeout(this.runningTimeoutId);
    }
  }
  async waitFor() {
    this.stop();
    if (this.isUpdating && this.runningPromise) return this.runningPromise;else return Promise.resolve();
  }
  setRunning(ruleId, namespace) {
    this.isUpdating = true;
    this.runningPromise = (0, _partially_update_rule.partiallyUpdateRule)(this.client, ruleId, {
      running: true
    }, {
      ignore404: true,
      namespace,
      refresh: false
    });
    this.runningPromise.then(() => {
      this.runningPromise = undefined;
      this.isUpdating = false;
    }).catch(err => {
      this.runningPromise = undefined;
      this.isUpdating = false;
      this.logger.error(`error updating running attribute rule for ${this.ruleTypeId}:${ruleId} ${err.message}`);
    });
  }
}
exports.RuleRunningHandler = RuleRunningHandler;