"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rawMaintenanceWindowSchema = exports.rRuleSchema = exports.alertsFilterQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsFilterQuerySchema = exports.alertsFilterQuerySchema = _configSchema.schema.object({
  kql: _configSchema.schema.string(),
  filters: _configSchema.schema.arrayOf(_configSchema.schema.object({
    query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
    meta: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
    $state: _configSchema.schema.maybe(_configSchema.schema.object({
      store: _configSchema.schema.oneOf([_configSchema.schema.literal(_esQuery.FilterStateStore.APP_STATE), _configSchema.schema.literal(_esQuery.FilterStateStore.GLOBAL_STATE)])
    }))
  })),
  dsl: _configSchema.schema.maybe(_configSchema.schema.string())
});
const rRuleSchema = exports.rRuleSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string(),
  tzid: _configSchema.schema.string(),
  freq: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4), _configSchema.schema.literal(5), _configSchema.schema.literal(6)])),
  until: _configSchema.schema.maybe(_configSchema.schema.string()),
  count: _configSchema.schema.maybe(_configSchema.schema.number()),
  interval: _configSchema.schema.maybe(_configSchema.schema.number()),
  wkst: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('MO'), _configSchema.schema.literal('TU'), _configSchema.schema.literal('WE'), _configSchema.schema.literal('TH'), _configSchema.schema.literal('FR'), _configSchema.schema.literal('SA'), _configSchema.schema.literal('SU')])),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number()])))),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number()))),
  bysetpos: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number()))),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number()))),
  byyearday: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number()))),
  byweekno: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number()))),
  byhour: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number()))),
  byminute: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number()))),
  bysecond: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.number())))
});
const rawMaintenanceWindowEventsSchema = _configSchema.schema.object({
  gte: _configSchema.schema.string(),
  lte: _configSchema.schema.string()
});
const rawMaintenanceWindowSchema = exports.rawMaintenanceWindowSchema = _configSchema.schema.object({
  categoryIds: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.arrayOf(_configSchema.schema.string()))),
  createdAt: _configSchema.schema.string(),
  createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
  duration: _configSchema.schema.number(),
  enabled: _configSchema.schema.boolean(),
  events: _configSchema.schema.arrayOf(rawMaintenanceWindowEventsSchema),
  expirationDate: _configSchema.schema.string(),
  rRule: rRuleSchema,
  scopedQuery: _configSchema.schema.maybe(_configSchema.schema.nullable(alertsFilterQuerySchema)),
  title: _configSchema.schema.string(),
  updatedAt: _configSchema.schema.string(),
  updatedBy: _configSchema.schema.nullable(_configSchema.schema.string())
});