"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toWeekdayName = exports.recurringSummary = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _rrule = require("@kbn/rrule");
var i18n = _interopRequireWildcard(require("../translations"));
var _constants = require("../constants");
var _month_day_date = require("./month_day_date");
var _get_nth_by_weekday = require("./get_nth_by_weekday");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const recurringSummary = (startDate, recurringSchedule, presets) => {
  var _schedule$customFrequ;
  if (!recurringSchedule) return '';
  let schedule = recurringSchedule;
  if (recurringSchedule.frequency !== 'CUSTOM') {
    schedule = {
      ...recurringSchedule,
      ...presets[recurringSchedule.frequency]
    };
  }
  const frequency = (_schedule$customFrequ = schedule.customFrequency) !== null && _schedule$customFrequ !== void 0 ? _schedule$customFrequ : schedule.frequency;
  const interval = schedule.interval || 1;
  const frequencySummary = i18n.CREATE_FORM_FREQUENCY_SUMMARY(interval)[frequency];

  // daily and weekly
  let weeklySummary = null;
  let dailyWeekdaySummary = null;
  let dailyWithWeekdays = false;
  const byweekday = schedule.byweekday;
  if (byweekday) {
    const weekdays = Object.keys(byweekday).filter(k => byweekday[k] === true).map(n => _constants.ISO_WEEKDAYS_TO_RRULE[Number(n)]);
    const formattedWeekdays = weekdays.map(weekday => toWeekdayName(weekday)).join(', ');
    weeklySummary = i18n.CREATE_FORM_WEEKLY_SUMMARY(formattedWeekdays);
    dailyWeekdaySummary = formattedWeekdays;
    dailyWithWeekdays = frequency === _rrule.Frequency.DAILY;
  }

  // monthly
  let monthlySummary = null;
  const bymonth = schedule.bymonth;
  if (bymonth) {
    if (bymonth === 'weekday') {
      const nthWeekday = (0, _get_nth_by_weekday.getNthByWeekday)(startDate);
      const nth = nthWeekday.startsWith('-1') ? 0 : Number(nthWeekday[1]);
      monthlySummary = i18n.CREATE_FORM_WEEKDAY_SHORT(toWeekdayName(nthWeekday))[nth];
      monthlySummary = monthlySummary[0].toLocaleLowerCase() + monthlySummary.slice(1);
    } else if (bymonth === 'day') {
      monthlySummary = i18n.CREATE_FORM_MONTHLY_BY_DAY_SUMMARY(startDate.date());
    }
  }

  // yearly
  const yearlyByMonthSummary = i18n.CREATE_FORM_YEARLY_BY_MONTH_SUMMARY((0, _month_day_date.monthDayDate)((0, _moment.default)().month(startDate.month()).date(startDate.date())));
  const onSummary = dailyWithWeekdays ? dailyWeekdaySummary : frequency === _rrule.Frequency.WEEKLY ? weeklySummary : frequency === _rrule.Frequency.MONTHLY ? monthlySummary : frequency === _rrule.Frequency.YEARLY ? yearlyByMonthSummary : null;
  const untilSummary = schedule.until ? i18n.CREATE_FORM_UNTIL_DATE_SUMMARY((0, _moment.default)(schedule.until).format('LL')) : schedule.count ? i18n.CREATE_FORM_OCURRENCES_SUMMARY(schedule.count) : null;
  const every = i18n.CREATE_FORM_RECURRING_SUMMARY(!dailyWithWeekdays ? frequencySummary : null, onSummary, untilSummary).trim();
  return every;
};
exports.recurringSummary = recurringSummary;
const toWeekdayName = weekday => (0, _moment.default)().isoWeekday(_constants.RRULE_WEEKDAYS_TO_ISO_WEEKDAYS[weekday.slice(-2)]).format('dddd');
exports.toWeekdayName = toWeekdayName;