"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTagsRequestQuerySchema = exports.ruleTagsFormattedResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../constants/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleTagsRequestQuerySchema = exports.ruleTagsRequestQuerySchema = _configSchema.schema.object({
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  per_page: _configSchema.schema.maybe(_configSchema.schema.number({
    defaultValue: _v.DEFAULT_TAGS_PER_PAGEV1,
    min: 1
  })),
  search: _configSchema.schema.maybe(_configSchema.schema.string())
});
const ruleTagsFormattedResponseSchema = exports.ruleTagsFormattedResponseSchema = _configSchema.schema.object({
  total: _configSchema.schema.number(),
  page: _configSchema.schema.number(),
  perPage: _configSchema.schema.number(),
  data: _configSchema.schema.arrayOf(_configSchema.schema.string())
});