"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleIdsWithGapResponseSchema = exports.getRuleIdsWithGapBodySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleIdsWithGapBodySchema = exports.getRuleIdsWithGapBodySchema = _configSchema.schema.object({
  end: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  statuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}, {
  validate({
    start,
    end
  }) {
    const parsedStart = Date.parse(start);
    if (isNaN(parsedStart)) {
      return `[start]: query start must be valid date`;
    }
    const parsedEnd = Date.parse(end);
    if (isNaN(parsedEnd)) {
      return `[end]: query end must be valid date`;
    }
    if (parsedStart >= parsedEnd) {
      return `[start]: query start must be before end`;
    }
  }
});
const getRuleIdsWithGapResponseSchema = exports.getRuleIdsWithGapResponseSchema = _configSchema.schema.object({
  total: _configSchema.schema.number(),
  rule_ids: _configSchema.schema.arrayOf(_configSchema.schema.string())
});