"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiopsPlugin = void 0;
var _rxjs = require("rxjs");
var _shared_components = require("./shared_components");
var _shared_lazy_components = require("./shared_lazy_components");
var _embeddables = require("./embeddables");
var _ui_actions = require("./ui_actions");
var _register_cases = require("./cases/register_cases");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AiopsPlugin {
  setup(core, {
    embeddable,
    cases,
    licensing,
    uiActions
  }) {
    Promise.all([(0, _rxjs.firstValueFrom)(licensing.license$), core.getStartServices()]).then(([license, [coreStart, pluginStart]]) => {
      const {
        canUseAiops
      } = coreStart.application.capabilities.ml;
      if (license.hasAtLeast('platinum') && canUseAiops) {
        if (embeddable) {
          (0, _embeddables.registerEmbeddables)(embeddable, core);
        }
        if (uiActions) {
          (0, _ui_actions.registerAiopsUiActions)(uiActions, coreStart, pluginStart);
        }
        if (cases) {
          (0, _register_cases.registerCases)(cases, coreStart, pluginStart);
        }
      }
    });
  }
  start(core, plugins) {
    return {
      ChangePointDetectionComponent: (0, _shared_components.getChangePointDetectionComponent)(core, plugins),
      getPatternAnalysisAvailable: async () => {
        const {
          getPatternAnalysisAvailable
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_categorization/log_categorization_enabled')));
        return getPatternAnalysisAvailable(plugins.licensing);
      },
      PatternAnalysisComponent: _shared_lazy_components.LogCategorizationForDiscover
    };
  }
  stop() {}
}
exports.AiopsPlugin = AiopsPlugin;