"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMarkedDuplicates = getMarkedDuplicates;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Analyse duplicate field/value pairs in groups.
 */
function getMarkedDuplicates(cpgs, fieldValuePairCounts) {
  return cpgs.map(cpg => {
    return {
      ...cpg,
      group: cpg.group.map(g => {
        return {
          ...g,
          duplicate: fieldValuePairCounts[g.fieldName][g.fieldValue]
        };
      })
    };
  });
}