"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantManagementSelectionPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _configSchema = require("@kbn/config-schema");
var _constants = require("../common/constants");
var _ai_assistant_type = require("../common/ai_assistant_type");
var _ui_setting_keys = require("../common/ui_setting_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class AIAssistantManagementSelectionPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    var _plugins$features;
    core.uiSettings.register({
      [_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY]: {
        name: _i18n.i18n.translate('aiAssistantManagementSelection.preferredAIAssistantTypeSettingName', {
          defaultMessage: 'AI Assistant for Observability and Search visibility'
        }),
        category: [_server.DEFAULT_APP_CATEGORIES.observability.id],
        value: this.config.preferredAIAssistantType,
        description: _i18n.i18n.translate('aiAssistantManagementSelection.preferredAIAssistantTypeSettingDescription', {
          defaultMessage: '<em>[technical preview]</em> Whether to show the AI Assistant menu item in Observability and Search, everywhere, or nowhere.',
          values: {
            em: chunks => `<em>${chunks}</em>`
          }
        }),
        schema: _configSchema.schema.oneOf([_configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Default), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Observability), _configSchema.schema.literal(_ai_assistant_type.AIAssistantType.Never)], {
          defaultValue: this.config.preferredAIAssistantType
        }),
        options: [_ai_assistant_type.AIAssistantType.Default, _ai_assistant_type.AIAssistantType.Observability, _ai_assistant_type.AIAssistantType.Never],
        type: 'select',
        optionLabels: {
          [_ai_assistant_type.AIAssistantType.Default]: _i18n.i18n.translate('aiAssistantManagementSelection.preferredAIAssistantTypeSettingValueDefault', {
            defaultMessage: 'Observability and Search only (default)'
          }),
          [_ai_assistant_type.AIAssistantType.Observability]: _i18n.i18n.translate('aiAssistantManagementSelection.preferredAIAssistantTypeSettingValueObservability', {
            defaultMessage: 'Everywhere'
          }),
          [_ai_assistant_type.AIAssistantType.Never]: _i18n.i18n.translate('aiAssistantManagementSelection.preferredAIAssistantTypeSettingValueNever', {
            defaultMessage: 'Nowhere'
          })
        },
        requiresPageReload: true,
        solution: 'oblt'
      }
    });
    core.uiSettings.register({
      [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR]: {
        readonlyMode: 'ui',
        readonly: false,
        schema: _configSchema.schema.string(),
        value: _constants.NO_DEFAULT_CONNECTOR
      }
    });
    core.uiSettings.register({
      [_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY]: {
        readonlyMode: 'ui',
        readonly: false,
        schema: _configSchema.schema.boolean(),
        value: false
      }
    });
    core.capabilities.registerProvider(() => {
      return {
        management: {
          kibana: {
            aiAssistantManagementSelection: true,
            observabilityAiAssistantManagement: true,
            securityAiAssistantManagement: true
          }
        }
      };
    });
    (_plugins$features = plugins.features) === null || _plugins$features === void 0 ? void 0 : _plugins$features.registerKibanaFeature({
      id: 'aiAssistantManagementSelection',
      name: _i18n.i18n.translate('aiAssistantManagementSelection.featureRegistry.featureName', {
        defaultMessage: 'AI Assistant'
      }),
      order: 8600,
      app: [],
      category: _server.DEFAULT_APP_CATEGORIES.management,
      management: {
        kibana: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
      },
      minimumLicense: 'enterprise',
      privileges: {
        all: {
          management: {
            kibana: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
          },
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        },
        read: {
          management: {
            kibana: ['aiAssistantManagementSelection', 'securityAiAssistantManagement', 'observabilityAiAssistantManagement']
          },
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.AIAssistantManagementSelectionPlugin = AIAssistantManagementSelectionPlugin;