"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiConfirmModal = exports.CONFIRM_BUTTON = exports.CANCEL_BUTTON = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _modal = require("./modal");
var _modal_footer = require("./modal_footer");
var _modal_header = require("./modal_header");
var _modal_header_title = require("./modal_header_title");
var _modal_body = require("./modal_body");
var _services = require("../../services");
var _modal2 = require("./modal.styles");
var _button = require("../button");
var _text = require("../text");
var _react2 = require("@emotion/react");
var _excluded = ["children", "title", "titleProps", "onCancel", "onConfirm", "cancelButtonText", "confirmButtonText", "confirmButtonDisabled", "className", "buttonColor", "defaultFocusedButton", "isLoading"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var CONFIRM_BUTTON = exports.CONFIRM_BUTTON = 'confirm';
var CANCEL_BUTTON = exports.CANCEL_BUTTON = 'cancel';
var EuiConfirmModal = exports.EuiConfirmModal = function EuiConfirmModal(_ref) {
  var children = _ref.children,
    title = _ref.title,
    titleProps = _ref.titleProps,
    onCancel = _ref.onCancel,
    onConfirm = _ref.onConfirm,
    cancelButtonText = _ref.cancelButtonText,
    confirmButtonText = _ref.confirmButtonText,
    confirmButtonDisabled = _ref.confirmButtonDisabled,
    className = _ref.className,
    _ref$buttonColor = _ref.buttonColor,
    buttonColor = _ref$buttonColor === void 0 ? 'primary' : _ref$buttonColor,
    defaultFocusedButton = _ref.defaultFocusedButton,
    isLoading = _ref.isLoading,
    rest = _objectWithoutProperties(_ref, _excluded);
  var cancelButtonRef = (0, _react.useRef)(null);
  var confirmButtonRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    // We have to do this instead of using `autoFocus` because React's polyfill for auto-focusing
    // elements conflicts with the focus-trap logic we have on EuiModal.
    // Wait a beat for the focus-trap to complete, and then set focus to the right button. Check that
    // the buttons exist first, because it's possible the modal has been closed already.
    setTimeout(function () {
      if (defaultFocusedButton === CANCEL_BUTTON && cancelButtonRef.current) {
        cancelButtonRef.current.focus();
      } else if (defaultFocusedButton === CONFIRM_BUTTON && confirmButtonRef.current) {
        confirmButtonRef.current.focus();
      }
    });
  }, [defaultFocusedButton, cancelButtonRef, confirmButtonRef]);
  var classes = (0, _classnames.default)('euiModal--confirmation', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _modal2.euiModalStyles)(euiTheme);
  var cssStyles = [styles.confirmation];
  var modalTitle;
  if (title) {
    modalTitle = (0, _react2.jsx)(_modal_header.EuiModalHeader, null, (0, _react2.jsx)(_modal_header_title.EuiModalHeaderTitle, _extends({
      "data-test-subj": "confirmModalTitleText"
    }, titleProps), title));
  }
  var message;
  if (typeof children === 'string' && children.length > 0) {
    message = (0, _react2.jsx)("p", null, children);
  } else {
    message = children;
  }
  return (0, _react2.jsx)(_modal.EuiModal, _extends({
    className: classes,
    css: cssStyles,
    onClose: onCancel,
    role: "alertdialog"
  }, rest), modalTitle, message && (0, _react2.jsx)(_modal_body.EuiModalBody, null, (0, _react2.jsx)(_text.EuiText, {
    "data-test-subj": "confirmModalBodyText"
  }, message)), (0, _react2.jsx)(_modal_footer.EuiModalFooter, null, (0, _react2.jsx)(_button.EuiButtonEmpty, {
    "data-test-subj": "confirmModalCancelButton",
    onClick: onCancel,
    buttonRef: cancelButtonRef
  }, cancelButtonText), (0, _react2.jsx)(_button.EuiButton, {
    "data-test-subj": "confirmModalConfirmButton",
    onClick: onConfirm,
    isLoading: isLoading,
    fill: true,
    buttonRef: confirmButtonRef,
    color: buttonColor,
    isDisabled: confirmButtonDisabled
  }, confirmButtonText)));
};
EuiConfirmModal.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node,
  title: _propTypes.default.node,
  titleProps: _propTypes.default.any,
  cancelButtonText: _propTypes.default.node,
  confirmButtonText: _propTypes.default.node,
  onCancel: _propTypes.default.func.isRequired,
  onConfirm: _propTypes.default.func,
  confirmButtonDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  /**
     * Allows focusing either the confirm or cancel button on modal initialization.
     * Will take precedence over `initialFocus`, if `initialFocus` is passed.
     */
  defaultFocusedButton: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  buttonColor: _propTypes.default.any,
  // For docs only, will get passed with ...rest
  /**
     * Sets the max-width of the modal.
     * Set to `true` to use the default (`euiBreakpoints 'm'`),
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  maxWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
     * Passes `isLoading` prop to the confirm button
     */
  isLoading: _propTypes.default.bool
};