"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiErrorBoundaryStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiErrorBoundaryStyles = exports.euiErrorBoundaryStyles = function euiErrorBoundaryStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var color1 = (0, _services.transparentize)(euiTheme.colors.danger, highContrastMode ? 1 : 0.25);
  var color2 = (0, _services.transparentize)(euiTheme.colors.danger, highContrastMode ? 0.25 : 0.05);
  return {
    euiErrorBoundary: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.base), " ", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: "\n          background-image: repeating-linear-gradient(\n            45deg,\n            ".concat(color1, ",\n            ").concat(color1, " 1px,\n            ").concat(color2, " 1px,\n            ").concat(color2, " 19px\n          );\n          background-size: 54px 54px; /* Fix for Safari 15.4+ */\n        "),
      // Windows high contrast themes ignore background-images that aren't url()s.
      // We can fake a basic danger-colored "border" with a little inline SVG trickery
      forced: "\n          background-image: url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg'%3E%3Crect width='100%25' height='100%25' fill='".concat(encodeURIComponent(euiTheme.colors.textDanger), "' /%3E%3C/svg%3E\");\n        ")
    }), ";;label:euiErrorBoundary;")
  };
};