"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiNotificationBadge = exports.COLORS = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _badge_notification = require("./badge_notification.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "size", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var COLORS = exports.COLORS = ['accent', 'subdued', 'success'];
var SIZES = exports.SIZES = ['s', 'm'];
var EuiNotificationBadge = exports.EuiNotificationBadge = function EuiNotificationBadge(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'accent' : _ref$color,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiNotificationBadge', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_badge_notification.euiNotificationBadgeStyles);
  var cssStyles = [styles.euiNotificationBadge, styles[size], styles[color]];
  return (0, _react2.jsx)("span", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
};
EuiNotificationBadge.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node.isRequired,
  size: _propTypes.default.any,
  color: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};