"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NavButtonControlledZoomPanHistory = exports.PushZoomPanToQueueTip = exports.ClearQueueTipAndAddClick = exports.InsertClicksEverywhere = exports.NavigationStrategy = void 0;
function isZoomPanNav(nav) {
    return nav && Number.isNaN(nav.index);
}
class NavigationStrategy {
    navIndex = 0;
    navQueue = [];
    root;
    lastZoom;
    constructor(root) {
        this.root = root;
        this.navQueue.push(this.root);
    }
    navForward() {
        if (!this.canNavForward()) {
            return;
        }
        this.navIndex++;
        return this.current();
    }
    navBackward() {
        if (!this.canNavBackward()) {
            return;
        }
        this.navIndex--;
        return this.current();
    }
    canNavForward = () => this.navIndex < this.navQueue.length - 1;
    canNavBackward = () => this.navQueue.length > 0 && this.navIndex > 0;
    current = () => this.navQueue[this.navIndex];
    next = () => this.navQueue[this.navIndex + 1];
    prev = () => this.navQueue[this.navIndex - 1];
    reset() {
        this.navIndex = 0;
        this.navQueue.splice(this.navIndex, Infinity, this.root);
    }
    backToTop = () => (this.navIndex = 0);
    queue = () => this.navQueue;
    index = () => this.navIndex;
    lastInQueue = () => this.navIndex === this.navQueue.length - 1;
}
exports.NavigationStrategy = NavigationStrategy;
class InsertClicksEverywhere extends NavigationStrategy {
    add(toAdd) {
        if (isZoomPanNav(toAdd)) {
            return;
        }
        if (this.current()?.index !== toAdd.index) {
            this.navQueue.splice(++this.navIndex, 0, toAdd);
        }
    }
}
exports.InsertClicksEverywhere = InsertClicksEverywhere;
class ClearQueueTipAndAddClick extends NavigationStrategy {
    add(toAdd) {
        if (isZoomPanNav(toAdd)) {
            return;
        }
        if (this.current()?.index !== toAdd.index) {
            this.navQueue.splice(++this.navIndex, Infinity, toAdd);
        }
    }
}
exports.ClearQueueTipAndAddClick = ClearQueueTipAndAddClick;
class PushZoomPanToQueueTip extends NavigationStrategy {
    add(toAdd) {
        if (isZoomPanNav(toAdd)) {
            if (!this.lastInQueue()) {
                return;
            }
            else {
                if (isZoomPanNav(this.current())) {
                    this.navQueue.splice(this.navIndex, 1, toAdd);
                }
                else {
                    this.navQueue.splice(++this.navIndex, 0, toAdd);
                }
            }
        }
        else {
            if (this.lastInQueue()) {
                if (isZoomPanNav(this.current())) {
                    this.navQueue.splice(this.navIndex, 1, toAdd);
                }
                else {
                    if (this.current()?.index !== toAdd.index) {
                        this.navQueue.splice(++this.navIndex, 0, toAdd);
                    }
                }
            }
            else {
                if (this.current()?.index !== toAdd.index) {
                    this.navQueue.splice(++this.navIndex, Infinity, toAdd);
                }
            }
        }
    }
}
exports.PushZoomPanToQueueTip = PushZoomPanToQueueTip;
class NavButtonControlledZoomPanHistory extends NavigationStrategy {
    navForward() {
        if (!this.canNavForward()) {
            return;
        }
        if (this.lastZoom) {
            this.navQueue.splice(++this.navIndex, 0, { ...this.lastZoom });
            this.lastZoom = undefined;
        }
        this.navIndex++;
        return this.current();
    }
    navBackward() {
        if (!this.canNavBackward()) {
            return;
        }
        if (this.lastZoom) {
            this.navQueue.splice(++this.navIndex, 0, { ...this.lastZoom });
            this.lastZoom = undefined;
        }
        this.navIndex--;
        return this.current();
    }
    add(toAdd) {
        if (isZoomPanNav(toAdd)) {
            this.lastZoom = { ...toAdd };
        }
        else {
            this.lastZoom = undefined;
            if (this.current()?.index !== toAdd.index) {
                this.navQueue.splice(++this.navIndex, Infinity, toAdd);
            }
        }
    }
}
exports.NavButtonControlledZoomPanHistory = NavButtonControlledZoomPanHistory;
//# sourceMappingURL=navigation.js.map