"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENDPOINT_PRIVILEGES = exports.ENDPOINT_EXCEPTIONS_PRIVILEGES = void 0;
var _std = require("@kbn/std");
var _coreApplicationCommon = require("@kbn/core-application-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_SOLUTION_APP_ID = 'siemV2';
/**
 * defines endpoint package privileges
 * the key is the name of the packagePrivilege (ie. 'readSecuritySolution')
 * the value object is for mapping kibana privileges and capabilities
 * see x-pack/platform/plugins/shared/fleet/server/services/security/security.ts for example of how object values are used
 */
const ENDPOINT_PRIVILEGES = exports.ENDPOINT_PRIVILEGES = (0, _std.deepFreeze)({
  readSecuritySolution: {
    appId: SECURITY_SOLUTION_APP_ID,
    privilegeSplit: '/',
    privilegeType: 'ui',
    privilegeName: 'show'
  },
  writeSecuritySolution: {
    appId: SECURITY_SOLUTION_APP_ID,
    privilegeSplit: '/',
    privilegeType: 'ui',
    privilegeName: 'crud'
  },
  writeEndpointList: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeEndpointList'
  },
  readEndpointList: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readEndpointList'
  },
  writeTrustedApplications: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeTrustedApplications'
  },
  readTrustedApplications: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readTrustedApplications'
  },
  writeHostIsolationExceptions: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeHostIsolationExceptions'
  },
  readHostIsolationExceptions: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readHostIsolationExceptions'
  },
  accessHostIsolationExceptions: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'accessHostIsolationExceptions'
  },
  deleteHostIsolationExceptions: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'deleteHostIsolationExceptions'
  },
  writeBlocklist: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeBlocklist'
  },
  readBlocklist: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readBlocklist'
  },
  writeEventFilters: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeEventFilters'
  },
  readEventFilters: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readEventFilters'
  },
  writeGlobalArtifacts: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeGlobalArtifacts'
  },
  writePolicyManagement: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writePolicyManagement'
  },
  readPolicyManagement: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readPolicyManagement'
  },
  writeActionsLogManagement: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeActionsLogManagement'
  },
  readActionsLogManagement: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readActionsLogManagement'
  },
  writeHostIsolation: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeHostIsolation'
  },
  writeHostIsolationRelease: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeHostIsolationRelease'
  },
  writeProcessOperations: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeProcessOperations'
  },
  writeFileOperations: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeFileOperations'
  },
  writeExecuteOperations: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeExecuteOperations'
  },
  writeScanOperations: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeScanOperations'
  },
  writeWorkflowInsights: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'writeWorkflowInsights'
  },
  readWorkflowInsights: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'readWorkflowInsights'
  }
});
const ENDPOINT_EXCEPTIONS_PRIVILEGES = exports.ENDPOINT_EXCEPTIONS_PRIVILEGES = (0, _std.deepFreeze)({
  showEndpointExceptions: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'showEndpointExceptions'
  },
  crudEndpointExceptions: {
    appId: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    privilegeSplit: '-',
    privilegeType: 'api',
    privilegeName: 'crudEndpointExceptions'
  }
});