"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlLabel = ControlLabel;
exports.ControlType = ControlType;
exports.ControlWidth = ControlWidth;
exports.Footer = Footer;
exports.Header = Header;
exports.VariableName = VariableName;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _visualizationUtils = require("@kbn/visualization-utils");
var _eui = require("@elastic/eui");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const controlTypeOptions = [{
  label: _i18n.i18n.translate('esql.flyout.controlTypeOptions.staticValuesLabel', {
    defaultMessage: 'Static values'
  }),
  'data-test-subj': 'staticValues',
  key: _types.EsqlControlType.STATIC_VALUES
}, {
  label: _i18n.i18n.translate('esql.flyout.controlTypeOptions.valuesFromQueryLabel', {
    defaultMessage: 'Values from a query'
  }),
  'data-test-subj': 'valuesFromQuery',
  key: _types.EsqlControlType.VALUES_FROM_QUERY
}];
const minimumWidthButtonGroup = [{
  id: `small`,
  label: _i18n.i18n.translate('esql.flyout.minimumWidth.small', {
    defaultMessage: 'Small'
  })
}, {
  id: `medium`,
  label: _i18n.i18n.translate('esql.flyout.minimumWidth.medium', {
    defaultMessage: 'Medium'
  })
}, {
  id: `large`,
  label: _i18n.i18n.translate('esql.flyout.minimumWidth.large', {
    defaultMessage: 'Large'
  })
}];
function ControlType({
  isDisabled,
  initialControlFlyoutType,
  onFlyoutTypeChange
}) {
  const controlFlyoutType = controlTypeOptions.find(option => option.key === initialControlFlyoutType);
  const onTypeChange = (0, _react.useCallback)(selectedOptions => {
    const flyoutType = controlTypeOptions.find(option => option.key === selectedOptions[0].key);
    onFlyoutTypeChange === null || onFlyoutTypeChange === void 0 ? void 0 : onFlyoutTypeChange(flyoutType.key);
  }, [onFlyoutTypeChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_visualizationUtils.TooltipWrapper, {
    tooltipContent: _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.disabledTooltip', {
      defaultMessage: 'Currently, only the [Static values] type is available to replace functions or field names.'
    }),
    condition: isDisabled,
    anchorProps: {
      css: {
        width: '100%'
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.label', {
      defaultMessage: 'Type'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.placeholder', {
      defaultMessage: 'Select a control type'
    }),
    placeholder: _i18n.i18n.translate('esql.flyout.controlTypeOptionsOptions.placeholder', {
      defaultMessage: 'Select a control type'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: controlTypeOptions,
    selectedOptions: [controlFlyoutType],
    onChange: onTypeChange,
    fullWidth: true,
    isDisabled: isDisabled,
    compressed: true,
    "data-test-subj": "esqlControlTypeDropdown",
    inputPopoverProps: {
      'data-test-subj': 'esqlControlTypeInputPopover'
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}
function VariableName({
  variableName,
  isControlInEditMode,
  esqlVariables = [],
  onVariableNameChange
}) {
  const genericContent = _i18n.i18n.translate('esql.flyout.variableName.helpText', {
    defaultMessage: 'This name will be prefaced with a "?" in the editor'
  });
  const isDisabledTooltipText = _i18n.i18n.translate('esql.flyout.variableName.disabledTooltip', {
    defaultMessage: 'You can’t edit a control name after it’s been created.'
  });
  const variableExists = esqlVariables.some(variable => variable.key === variableName.replace('?', '')) && !isControlInEditMode;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.variableName.label', {
      defaultMessage: 'Name'
    }),
    helpText: _i18n.i18n.translate('esql.flyout.variableName.helpText', {
      defaultMessage: 'This name will be prefaced with a "?" in the editor'
    }),
    fullWidth: true,
    autoFocus: true,
    isInvalid: !variableName || variableExists,
    error: !variableName ? _i18n.i18n.translate('esql.flyout.variableName.error', {
      defaultMessage: 'Variable name is required'
    }) : variableExists ? _i18n.i18n.translate('esql.flyout.variableNameExists.error', {
      defaultMessage: 'Variable name already exists'
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isControlInEditMode ? isDisabledTooltipText : genericContent,
    css: (0, _react2.css)`
          width: 100%;
        `,
    display: "block"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('esql.flyout.variableName.placeholder', {
      defaultMessage: 'Set a variable name'
    }),
    value: variableName,
    onChange: onVariableNameChange,
    "aria-label": _i18n.i18n.translate('esql.flyout.variableName.placeholder', {
      defaultMessage: 'Set a variable name'
    }),
    "data-test-subj": "esqlVariableName",
    fullWidth: true,
    disabled: isControlInEditMode,
    compressed: true
  })));
}
function ControlLabel({
  label,
  onLabelChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.label.label', {
      defaultMessage: 'Label'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, _i18n.i18n.translate('esql.flyout.label.extraLabel', {
      defaultMessage: 'Optional'
    }))),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('esql.flyout.label.placeholder', {
      defaultMessage: 'Set a label'
    }),
    value: label,
    onChange: onLabelChange,
    "aria-label": _i18n.i18n.translate('esql.flyout.label.placeholder', {
      defaultMessage: 'Set a label'
    }),
    "data-test-subj": "esqlControlLabel",
    fullWidth: true,
    compressed: true
  }));
}
function ControlWidth({
  minimumWidth,
  grow,
  onMinimumSizeChange,
  onGrowChange
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('esql.flyout.minimumWidth.label', {
      defaultMessage: 'Minimum width'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('esql.flyout.minimumWidth.label', {
      defaultMessage: 'Minimum width'
    }),
    options: minimumWidthButtonGroup,
    idSelected: minimumWidth,
    onChange: id => onMinimumSizeChange(id),
    type: "single",
    isFullWidth: true,
    "data-test-subj": "esqlControlMinimumWidth"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('esql.flyout.grow.label', {
      defaultMessage: 'Expand width to fit available space'
    }),
    color: "primary",
    checked: grow !== null && grow !== void 0 ? grow : false,
    onChange: e => onGrowChange(e),
    "data-test-subj": "esqlControlGrow"
  }));
}
function Header({
  isInEditMode
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isInEditMode ? _i18n.i18n.translate('esql.flyout.editTitle', {
    defaultMessage: 'Edit ES|QL control'
  }) : _i18n.i18n.translate('esql.flyout.title', {
    defaultMessage: 'Create ES|QL control'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: _i18n.i18n.translate('esql.flyout.experimentalLabel.title', {
      defaultMessage: 'Technical preview'
    }),
    content: _i18n.i18n.translate('esql.flyout.experimentalLabel.content', {
      defaultMessage: 'ES|QL variables are currently on Technical preview.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: "",
    iconType: "beaker",
    size: "s",
    css: (0, _react2.css)`
                vertical-align: middle;
              `
  })))));
}
function Footer({
  isControlInEditMode,
  variableName,
  onCancelControl,
  isSaveDisabled,
  closeFlyout,
  onCreateControl
}) {
  const onCancel = (0, _react.useCallback)(() => {
    closeFlyout();
    onCancelControl === null || onCancelControl === void 0 ? void 0 : onCancelControl();
  }, [closeFlyout, onCancelControl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    id: "lnsCancelEditOnFlyFlyout",
    onClick: onCancel,
    flush: "left",
    "aria-label": _i18n.i18n.translate('esql.flyout..cancelFlyoutAriaLabel', {
      defaultMessage: 'Cancel applied changes'
    }),
    "data-test-subj": "cancelEsqlControlsFlyoutButton"
  }, _i18n.i18n.translate('esql.flyout.cancelLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCreateControl,
    fill: true,
    "aria-label": _i18n.i18n.translate('esql.flyout..applyFlyoutAriaLabel', {
      defaultMessage: 'Apply changes'
    }),
    disabled: isSaveDisabled,
    color: "primary",
    iconType: "check",
    "data-test-subj": "saveEsqlControlsFlyoutButton"
  }, _i18n.i18n.translate('esql.flyout.saveLabel', {
    defaultMessage: 'Save'
  })))));
}