"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggest = suggest;
var _factories = require("../../factories");
var _complete_items = require("../../complete_items");
var _helper = require("../../helper");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function suggest(innerText, command, getColumnsByType, _columnExists, getSuggestedVariableName, _getExpressionType, getPreferences) {
  var _await$getPreferences, _await$getPreferences2;
  const pos = (0, _util.getPosition)(innerText, command);
  const columnSuggestions = (0, _helper.pushItUpInTheList)(await getColumnsByType('any', [], {
    advanceCursor: true,
    openSuggestions: true
  }), true);
  switch (pos) {
    case 'expression_without_assignment':
      return [...(0, _factories.getFunctionSuggestions)({
        command: 'stats'
      }), (0, _factories.getNewVariableSuggestion)(getSuggestedVariableName())];
    case 'expression_after_assignment':
      return [...(0, _factories.getFunctionSuggestions)({
        command: 'stats'
      })];
    case 'expression_complete':
      return [_util.byCompleteItem, _complete_items.pipeCompleteItem, {
        ..._complete_items.commaCompleteItem,
        command: _factories.TRIGGER_SUGGESTION_COMMAND,
        text: ', '
      }];
    case 'grouping_expression_after_assignment':
      return [...(0, _factories.getFunctionSuggestions)({
        command: 'stats',
        option: 'by'
      }), (0, _util.getDateHistogramCompletionItem)((_await$getPreferences = await (getPreferences === null || getPreferences === void 0 ? void 0 : getPreferences())) === null || _await$getPreferences === void 0 ? void 0 : _await$getPreferences.histogramBarTarget), ...columnSuggestions];
    case 'grouping_expression_without_assignment':
      return [...(0, _factories.getFunctionSuggestions)({
        command: 'stats',
        option: 'by'
      }), (0, _util.getDateHistogramCompletionItem)((_await$getPreferences2 = await (getPreferences === null || getPreferences === void 0 ? void 0 : getPreferences())) === null || _await$getPreferences2 === void 0 ? void 0 : _await$getPreferences2.histogramBarTarget), ...columnSuggestions, (0, _factories.getNewVariableSuggestion)(getSuggestedVariableName())];
    case 'grouping_expression_complete':
      return [_complete_items.pipeCompleteItem, {
        ..._complete_items.commaCompleteItem,
        command: _factories.TRIGGER_SUGGESTION_COMMAND,
        text: ', '
      }];
    default:
      return [];
  }
}