"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchRoutes = exports.searchEntitiesRoute = exports.searchEntitiesPreviewRoute = void 0;
var _zod = require("@kbn/zod");
var _create_entity_manager_server_route = require("../create_entity_manager_server_route");
var _unknown_entity_type = require("../../lib/v2/errors/unknown_entity_type");
var _types = require("../../lib/v2/types");
var _constants = require("../../lib/v2/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const searchEntitiesRoute = exports.searchEntitiesRoute = (0, _create_entity_manager_server_route.createEntityManagerServerRoute)({
  endpoint: 'POST /internal/entities/v2/_search',
  security: {
    authz: {
      requiredPrivileges: [_constants.READ_ENTITIES_PRIVILEGE]
    }
  },
  params: _zod.z.object({
    body: _types.searchByTypeRt
  }),
  handler: async ({
    request,
    response,
    params,
    logger,
    getScopedClient
  }) => {
    try {
      const client = await getScopedClient({
        request
      });
      const result = await client.v2.searchEntities(params.body);
      return response.ok({
        body: result
      });
    } catch (e) {
      logger.error(e);
      if (e instanceof _unknown_entity_type.UnknownEntityType) {
        return response.notFound({
          body: e
        });
      }
      return response.customError({
        body: e,
        statusCode: 500
      });
    }
  }
});
const searchEntitiesPreviewRoute = exports.searchEntitiesPreviewRoute = (0, _create_entity_manager_server_route.createEntityManagerServerRoute)({
  endpoint: 'POST /internal/entities/v2/_search/preview',
  security: {
    authz: {
      requiredPrivileges: [_constants.READ_ENTITIES_PRIVILEGE]
    }
  },
  params: _zod.z.object({
    body: _types.searchBySourcesRt
  }),
  handler: async ({
    request,
    response,
    params,
    getScopedClient
  }) => {
    const client = await getScopedClient({
      request
    });
    const result = await client.v2.searchEntitiesBySources(params.body);
    return response.ok({
      body: result
    });
  }
});
const searchRoutes = exports.searchRoutes = {
  ...searchEntitiesRoute,
  ...searchEntitiesPreviewRoute
};