"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.installBuiltInDefinitions = installBuiltInDefinitions;
var _type_definition = require("./type_definition");
var _source_definition = require("./source_definition");
var _built_in = require("./built_in");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function installBuiltInDefinitions(clusterClient, logger) {
  logger.info('Installing built in entity definitions');
  const types = [];
  const sources = [];
  for (const definition of _built_in.builtInDefinitions) {
    types.push(definition.type);
    sources.push(...definition.sources);
  }
  const typeInstallations = await Promise.allSettled(types.map(type => (0, _type_definition.storeTypeDefinition)({
    type,
    clusterClient,
    logger,
    replace: true
  })));
  typeInstallations.forEach(installation => {
    if (installation.status === 'rejected') {
      logger.error(installation.reason);
    }
  });
  const sourceInstallations = await Promise.allSettled(sources.map(source => (0, _source_definition.storeSourceDefinition)({
    source,
    clusterClient,
    logger,
    replace: true
  })));

  // This may fail because the type installation failed and storeSourceDefinition verifies that the type exists first
  // It may also fail for other reasons but we continue in case there are more sources for the same type that might succeed
  sourceInstallations.forEach(installation => {
    if (installation.status === 'rejected') {
      logger.error(installation.reason);
    }
  });
}