"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builtInKubernetesStatefulSetEcsEntityDefinition = void 0;
var _constants = require("../../constants");
var _ecs_index_patterns = require("./ecs_index_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const builtInKubernetesStatefulSetEcsEntityDefinition = exports.builtInKubernetesStatefulSetEcsEntityDefinition = {
  type: {
    id: `${_constants.BUILT_IN_ID_PREFIX}kubernetes_stateful_set_ecs`,
    display_name: 'Kubernetes StatefulSets (ECS)'
  },
  sources: [{
    id: `${_constants.BUILT_IN_ID_PREFIX}kubernetes_stateful_set_ecs_ecs`,
    type_id: `${_constants.BUILT_IN_ID_PREFIX}kubernetes_stateful_set_ecs`,
    index_patterns: _ecs_index_patterns.commonEcsIndexPatterns,
    identity_fields: ['kubernetes.statefulset.name'],
    display_name: 'kubernetes.statefulset.name',
    timestamp_field: '@timestamp',
    metadata_fields: [],
    filters: ['kubernetes.statefulset.name: *']
  }]
};